/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.launch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.helper.HackHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;

public class LegacyLaunch
implements Launch {
    private LegacyClassLoader legacyClassLoader;
    private MethodHandles.Lookup hackLookup;

    @Override
    public ClassLoaderControl init(List<Path> list, String string, LaunchOptions launchOptions) {
        this.legacyClassLoader = new LegacyClassLoader((URL[])list.stream().map(path -> {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }).toArray(URL[]::new), BasicLaunch.class.getClassLoader());
        this.legacyClassLoader.nativePath = string;
        if (launchOptions.enableHacks) {
            this.hackLookup = HackHelper.createHackLookup(BasicLaunch.class);
        }
        return this.legacyClassLoader.makeControl();
    }

    @Override
    public void launch(String string, String string2, Collection<String> collection) throws Throwable {
        Thread.currentThread().setContextClassLoader(this.legacyClassLoader);
        Class<?> clazz = Class.forName(string, true, this.legacyClassLoader);
        MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "main", MethodType.methodType(Void.TYPE, String[].class)).asFixedArity();
        JVMHelper.fullGC();
        methodHandle.asFixedArity().invokeWithArguments(new Object[]{collection.toArray(new String[0])});
    }

    private class LegacyClassLoader
    extends URLClassLoader {
        private final ClassLoader SYSTEM_CLASS_LOADER;
        private final List<ClassLoaderControl.ClassTransformer> transformers;
        private final Map<String, Class<?>> classMap;
        private String nativePath;
        private final List<String> packages;

        public LegacyClassLoader(URL[] uRLArray) {
            super(uRLArray);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl.ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packages = new ArrayList<String>();
            this.packages.add("pro.gravit.launcher.");
            this.packages.add("pro.gravit.utils.");
        }

        public LegacyClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
            this.SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
            this.transformers = new ArrayList<ClassLoaderControl.ClassTransformer>();
            this.classMap = new ConcurrentHashMap();
            this.packages = new ArrayList<String>();
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (string != null) {
                for (String string2 : this.packages) {
                    if (!string.startsWith(string2)) continue;
                    return this.SYSTEM_CLASS_LOADER.loadClass(string);
                }
            }
            return super.loadClass(string, bl);
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = this.classMap.get(string);
            if (clazz != null) {
                return clazz;
            }
            if (string != null && !this.transformers.isEmpty()) {
                boolean bl = false;
                for (ClassLoaderControl.ClassTransformer object : this.transformers) {
                    if (!object.filter(null, string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    String string2 = string.replace(".", "/").concat(".class");
                    try (InputStream iOException = this.getResourceAsStream(string2);){
                        byte[] byArray = IOHelper.read(iOException);
                        for (ClassLoaderControl.ClassTransformer classTransformer : this.transformers) {
                            byArray = classTransformer.transform(null, string, null, byArray);
                        }
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                    }
                    catch (IOException iOException2) {
                        throw new ClassNotFoundException(string, iOException2);
                    }
                }
            }
            if (clazz == null) {
                clazz = super.findClass(string);
            }
            if (clazz != null) {
                this.classMap.put(string, clazz);
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }

        @Override
        public String findLibrary(String string) {
            return this.nativePath.concat(IOHelper.PLATFORM_SEPARATOR).concat(JVMHelper.NATIVE_PREFIX).concat(string).concat(JVMHelper.NATIVE_EXTENSION);
        }

        public void addAllowedPackage(String string) {
            this.packages.add(string);
        }

        private LegacyClassLoaderControl makeControl() {
            return new LegacyClassLoaderControl();
        }

        public class LegacyClassLoaderControl
        implements ClassLoaderControl {
            @Override
            public void addLauncherPackage(String string) {
                LegacyClassLoader.this.addAllowedPackage(string);
            }

            @Override
            public void addTransformer(ClassLoaderControl.ClassTransformer classTransformer) {
                LegacyClassLoader.this.transformers.add(classTransformer);
            }

            @Override
            public void addURL(URL uRL) {
                LegacyClassLoader.this.addURL(uRL);
            }

            @Override
            public void addJar(Path path) {
                try {
                    LegacyClassLoader.this.addURL(path.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }

            @Override
            public URL[] getURLs() {
                return LegacyClassLoader.this.getURLs();
            }

            @Override
            public Class<?> getClass(String string) throws ClassNotFoundException {
                return Class.forName(string, false, LegacyClassLoader.this);
            }

            @Override
            public ClassLoader getClassLoader() {
                return LegacyClassLoader.this;
            }

            @Override
            public Object getJava9ModuleController() {
                return null;
            }

            @Override
            public MethodHandles.Lookup getHackLookup() {
                return LegacyLaunch.this.hackLookup;
            }
        }
    }
}

