/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocalThread;
import pro.gravit.repackage.io.netty.util.internal.ConcurrentSet;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

public final class ObjectCleaner {
    private static final int REFERENCE_QUEUE_POLL_TIMEOUT_MS = Math.max(500, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.util.internal.ObjectCleaner.refQueuePollTimeout", 10000));
    static final String CLEANER_THREAD_NAME = ObjectCleaner.class.getSimpleName() + "Thread";
    private static final Set<AutomaticCleanerReference> LIVE_SET = new ConcurrentSet<AutomaticCleanerReference>();
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private static final AtomicBoolean CLEANER_RUNNING = new AtomicBoolean(false);
    private static final Runnable CLEANER_TASK = new Runnable(){

        @Override
        public void run() {
            boolean bl = false;
            while (true) {
                if (!LIVE_SET.isEmpty()) {
                    AutomaticCleanerReference automaticCleanerReference;
                    try {
                        automaticCleanerReference = (AutomaticCleanerReference)REFERENCE_QUEUE.remove(REFERENCE_QUEUE_POLL_TIMEOUT_MS);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    if (automaticCleanerReference == null) continue;
                    try {
                        automaticCleanerReference.cleanup();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    LIVE_SET.remove(automaticCleanerReference);
                    continue;
                }
                CLEANER_RUNNING.set(false);
                if (LIVE_SET.isEmpty() || !CLEANER_RUNNING.compareAndSet(false, true)) break;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    };

    public static void register(Object object, Runnable runnable) {
        AutomaticCleanerReference automaticCleanerReference = new AutomaticCleanerReference(object, ObjectUtil.checkNotNull(runnable, "cleanupTask"));
        LIVE_SET.add(automaticCleanerReference);
        if (CLEANER_RUNNING.compareAndSet(false, true)) {
            final FastThreadLocalThread fastThreadLocalThread = new FastThreadLocalThread(CLEANER_TASK);
            fastThreadLocalThread.setPriority(1);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    fastThreadLocalThread.setContextClassLoader(null);
                    return null;
                }
            });
            fastThreadLocalThread.setName(CLEANER_THREAD_NAME);
            fastThreadLocalThread.setDaemon(true);
            fastThreadLocalThread.start();
        }
    }

    public static int getLiveSetCount() {
        return LIVE_SET.size();
    }

    private ObjectCleaner() {
    }

    private static final class AutomaticCleanerReference
    extends WeakReference<Object> {
        private final Runnable cleanupTask;

        AutomaticCleanerReference(Object object, Runnable runnable) {
            super(object, REFERENCE_QUEUE);
            this.cleanupTask = runnable;
        }

        void cleanup() {
            this.cleanupTask.run();
        }

        @Override
        public Thread get() {
            return null;
        }

        @Override
        public void clear() {
            LIVE_SET.remove(this);
            super.clear();
        }
    }
}

