/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionId;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionStats;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionTicketKey;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.internal.tcnative.SSLContext;
import pro.gravit.repackage.io.netty.internal.tcnative.SSLSessionCache;
import pro.gravit.repackage.io.netty.internal.tcnative.SessionTicketKey;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private final OpenSslSessionStats stats;
    private final OpenSslKeyMaterialProvider provider;
    final ReferenceCountedOpenSslContext context;
    private final OpenSslSessionCache sessionCache;
    private final long mask;

    OpenSslSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider, long l, OpenSslSessionCache openSslSessionCache) {
        this.context = referenceCountedOpenSslContext;
        this.provider = openSslKeyMaterialProvider;
        this.mask = l;
        this.stats = new OpenSslSessionStats(referenceCountedOpenSslContext);
        this.sessionCache = openSslSessionCache;
        SSLContext.setSSLSessionCache((long)referenceCountedOpenSslContext.ctx, (SSLSessionCache)openSslSessionCache);
    }

    final boolean useKeyManager() {
        return this.provider != null;
    }

    @Override
    public void setSessionCacheSize(int n) {
        ObjectUtil.checkPositiveOrZero(n, "size");
        this.sessionCache.setSessionCacheSize(n);
    }

    @Override
    public int getSessionCacheSize() {
        return this.sessionCache.getSessionCacheSize();
    }

    @Override
    public void setSessionTimeout(int n) {
        ObjectUtil.checkPositiveOrZero(n, "seconds");
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)n);
            this.sessionCache.setSessionTimeout(n);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionCache.getSessionTimeout();
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        return this.sessionCache.getSession(new OpenSslSessionId(byArray));
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return new Enumeration<byte[]>(){
            private final Iterator<OpenSslSessionId> ids;
            {
                this.ids = OpenSslSessionContext.this.sessionCache.getIds().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.ids.hasNext();
            }

            @Override
            public byte[] nextElement() {
                return this.ids.next().cloneBytes();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setTicketKeys(byte[] byArray) {
        if (byArray.length % 48 != 0) {
            throw new IllegalArgumentException("keys.length % 48 != 0");
        }
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[byArray.length / 48];
        int n = 0;
        for (int i = 0; i < sessionTicketKeyArray.length; ++i) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n, 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, n += 16, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray, n, 16);
            n += 16;
            sessionTicketKeyArray[i += 16] = new SessionTicketKey(byArray2, byArray3, byArray4);
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTicketKeys(OpenSslSessionTicketKey ... openSslSessionTicketKeyArray) {
        ObjectUtil.checkNotNull(openSslSessionTicketKeyArray, "keys");
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[openSslSessionTicketKeyArray.length];
        for (int i = 0; i < sessionTicketKeyArray.length; ++i) {
            sessionTicketKeyArray[i] = openSslSessionTicketKeyArray[i].key;
        }
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            if (sessionTicketKeyArray.length > 0) {
                SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionCacheEnabled(boolean bl) {
        long l = bl ? this.mask | SSL.SSL_SESS_CACHE_NO_INTERNAL_LOOKUP | SSL.SSL_SESS_CACHE_NO_INTERNAL_STORE : SSL.SSL_SESS_CACHE_OFF;
        Lock lock = this.context.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setSessionCacheMode((long)this.context.ctx, (long)l);
            if (!bl) {
                this.sessionCache.clear();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isSessionCacheEnabled() {
        Lock lock = this.context.ctxLock.readLock();
        lock.lock();
        try {
            boolean bl = (SSLContext.getSessionCacheMode((long)this.context.ctx) & this.mask) != 0L;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public OpenSslSessionStats stats() {
        return this.stats;
    }

    final void removeFromCache(OpenSslSessionId openSslSessionId) {
        this.sessionCache.removeSessionWithId(openSslSessionId);
    }

    final boolean isInCache(OpenSslSessionId openSslSessionId) {
        return this.sessionCache.containsSessionWithId(openSslSessionId);
    }

    void setSessionFromCache(String string, int n, long l) {
        this.sessionCache.setSession(l, string, n);
    }

    final void destroy() {
        if (this.provider != null) {
            this.provider.destroy();
        }
        this.sessionCache.clear();
    }
}

