/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterial;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.util.AbstractReferenceCounted;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;

final class OpenSslPrivateKey
extends AbstractReferenceCounted
implements PrivateKey {
    private long privateKeyAddress;

    OpenSslPrivateKey(long l) {
        this.privateKeyAddress = l;
    }

    @Override
    public String getAlgorithm() {
        return "unknown";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    private long privateKeyAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.privateKeyAddress;
    }

    @Override
    protected void deallocate() {
        SSL.freePrivateKey((long)this.privateKeyAddress);
        this.privateKeyAddress = 0L;
    }

    @Override
    public OpenSslPrivateKey retain() {
        super.retain();
        return this;
    }

    @Override
    public OpenSslPrivateKey retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public OpenSslPrivateKey touch() {
        super.touch();
        return this;
    }

    @Override
    public OpenSslPrivateKey touch(Object object) {
        return this;
    }

    @Override
    public void destroy() {
        this.release(this.refCnt());
    }

    @Override
    public boolean isDestroyed() {
        return this.refCnt() == 0;
    }

    OpenSslKeyMaterial newKeyMaterial(long l, X509Certificate[] x509CertificateArray) {
        return new OpenSslPrivateKeyMaterial(l, x509CertificateArray);
    }

    final class OpenSslPrivateKeyMaterial
    extends AbstractReferenceCounted
    implements OpenSslKeyMaterial {
        long certificateChain;
        private final X509Certificate[] x509CertificateChain;

        OpenSslPrivateKeyMaterial(long l, X509Certificate[] x509CertificateArray) {
            this.certificateChain = l;
            this.x509CertificateChain = x509CertificateArray == null ? EmptyArrays.EMPTY_X509_CERTIFICATES : x509CertificateArray;
            OpenSslPrivateKey.this.retain();
        }

        @Override
        public X509Certificate[] certificateChain() {
            return (X509Certificate[])this.x509CertificateChain.clone();
        }

        @Override
        public long certificateChainAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return this.certificateChain;
        }

        @Override
        public long privateKeyAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return OpenSslPrivateKey.this.privateKeyAddress();
        }

        @Override
        public OpenSslKeyMaterial touch(Object object) {
            OpenSslPrivateKey.this.touch(object);
            return this;
        }

        @Override
        public OpenSslKeyMaterial retain() {
            super.retain();
            return this;
        }

        @Override
        public OpenSslKeyMaterial retain(int n) {
            super.retain(n);
            return this;
        }

        @Override
        public OpenSslKeyMaterial touch() {
            OpenSslPrivateKey.this.touch();
            return this;
        }

        @Override
        protected void deallocate() {
            this.releaseChain();
            OpenSslPrivateKey.this.release();
        }

        private void releaseChain() {
            SSL.freeX509Chain((long)this.certificateChain);
            this.certificateChain = 0L;
        }
    }
}

