/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.util.AsciiString;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<HostPort, OpenSslSessionCache.NativeSslSession> sessions = new HashMap<HostPort, OpenSslSessionCache.NativeSslSession>();

    OpenSslClientSessionCache(OpenSslEngineMap openSslEngineMap) {
        super(openSslEngineMap);
    }

    @Override
    protected boolean sessionCreated(OpenSslSessionCache.NativeSslSession nativeSslSession) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(nativeSslSession.getPeerHost(), nativeSslSession.getPeerPort());
        if (hostPort == null || this.sessions.containsKey(hostPort)) {
            return false;
        }
        this.sessions.put(hostPort, nativeSslSession);
        return true;
    }

    @Override
    protected void sessionRemoved(OpenSslSessionCache.NativeSslSession nativeSslSession) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(nativeSslSession.getPeerHost(), nativeSslSession.getPeerPort());
        if (hostPort == null) {
            return;
        }
        this.sessions.remove(hostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setSession(long l, String string, int n) {
        boolean bl;
        OpenSslSessionCache.NativeSslSession nativeSslSession;
        HostPort hostPort = OpenSslClientSessionCache.keyFor(string, n);
        if (hostPort == null) {
            return;
        }
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            nativeSslSession = this.sessions.get(hostPort);
            if (nativeSslSession == null) {
                return;
            }
            if (!nativeSslSession.isValid()) {
                this.removeSessionWithId(nativeSslSession.sessionId());
                return;
            }
            bl = SSL.setSession((long)l, (long)nativeSslSession.session());
        }
        if (bl) {
            if (nativeSslSession.shouldBeSingleUse()) {
                nativeSslSession.invalidate();
            }
            nativeSslSession.updateLastAccessedTime();
        }
    }

    private static HostPort keyFor(String string, int n) {
        if (string == null && n < 1) {
            return null;
        }
        return new HostPort(string, n);
    }

    @Override
    synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }

    private static final class HostPort {
        private final int hash;
        private final String host;
        private final int port;

        HostPort(String string, int n) {
            this.host = string;
            this.port = n;
            this.hash = 31 * AsciiString.hashCode(string) + n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HostPort)) {
                return false;
            }
            HostPort hostPort = (HostPort)object;
            return this.port == hostPort.port && this.host.equalsIgnoreCase(hostPort.host);
        }

        public String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

