/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.spdy;

import java.util.zip.Deflater;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyCodecUtil;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyHeaderBlockRawEncoder;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyVersion;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

class SpdyHeaderBlockZlibEncoder
extends SpdyHeaderBlockRawEncoder {
    private final Deflater compressor;
    private boolean finished;

    SpdyHeaderBlockZlibEncoder(SpdyVersion spdyVersion, int n) {
        super(spdyVersion);
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n + " (expected: 0-9)");
        }
        this.compressor = new Deflater(n);
        this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
    }

    private int setInput(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            this.compressor.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n);
        } else {
            byte[] byArray = new byte[n];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray);
            this.compressor.setInput(byArray, 0, byArray.length);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf encode(ByteBufAllocator byteBufAllocator, int n) {
        ByteBuf byteBuf = byteBufAllocator.heapBuffer(n);
        boolean bl = true;
        try {
            while (this.compressInto(byteBuf)) {
                byteBuf.ensureWritable(byteBuf.capacity() << 1);
            }
            bl = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl) {
                byteBuf.release();
            }
        }
    }

    @SuppressJava6Requirement(reason="Guarded by java version check")
    private boolean compressInto(ByteBuf byteBuf) {
        byte[] byArray = byteBuf.array();
        int n = byteBuf.arrayOffset() + byteBuf.writerIndex();
        int n2 = byteBuf.writableBytes();
        int n3 = PlatformDependent.javaVersion() >= 7 ? this.compressor.deflate(byArray, n, n2, 2) : this.compressor.deflate(byArray, n, n2);
        byteBuf.writerIndex(byteBuf.writerIndex() + n3);
        return n3 == n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator byteBufAllocator, SpdyHeadersFrame spdyHeadersFrame) throws Exception {
        ObjectUtil.checkNotNullWithIAE(byteBufAllocator, "alloc");
        ObjectUtil.checkNotNullWithIAE(spdyHeadersFrame, "frame");
        if (this.finished) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = super.encode(byteBufAllocator, spdyHeadersFrame);
        try {
            if (!byteBuf.isReadable()) {
                ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
                return byteBuf2;
            }
            int n = this.setInput(byteBuf);
            ByteBuf byteBuf3 = this.encode(byteBufAllocator, n);
            return byteBuf3;
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public void end() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.compressor.end();
        super.end();
    }
}

