/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.CodecException;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class WebSocketClientExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketClientExtensionHandshaker> extensionHandshakers;

    public WebSocketClientExtensionHandler(WebSocketClientExtensionHandshaker ... webSocketClientExtensionHandshakerArray) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty(webSocketClientExtensionHandshakerArray, "extensionHandshakers"));
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (object instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade(((HttpRequest)object).headers())) {
            HttpRequest httpRequest = (HttpRequest)object;
            String string = httpRequest.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
            for (WebSocketClientExtensionHandshaker webSocketClientExtensionHandshaker : this.extensionHandshakers) {
                arrayList.add(webSocketClientExtensionHandshaker.newRequestData());
            }
            String string2 = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(string, arrayList);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)string2);
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        HttpResponse httpResponse;
        if (object instanceof HttpResponse && WebSocketExtensionUtil.isWebsocketUpgrade((httpResponse = (HttpResponse)object).headers())) {
            String string = httpResponse.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (string != null) {
                Object object2;
                Object object3;
                List<WebSocketExtensionData> list = WebSocketExtensionUtil.extractExtensions(string);
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                int n = 0;
                for (WebSocketExtensionData object4 : list) {
                    object3 = this.extensionHandshakers.iterator();
                    object2 = null;
                    while (object2 == null && object3.hasNext()) {
                        WebSocketClientExtensionHandshaker webSocketClientExtensionHandshaker = (WebSocketClientExtensionHandshaker)object3.next();
                        object2 = webSocketClientExtensionHandshaker.handshakeExtension(object4);
                    }
                    if (object2 != null && (object2.rsv() & n) == 0) {
                        n |= object2.rsv();
                        arrayList.add(object2);
                        continue;
                    }
                    throw new CodecException("invalid WebSocket Extension handshake for \"" + string + '\"');
                }
                for (WebSocketClientExtension webSocketClientExtension : arrayList) {
                    object3 = webSocketClientExtension.newExtensionDecoder();
                    object2 = webSocketClientExtension.newExtensionEncoder();
                    channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), object3.getClass().getName(), (ChannelHandler)object3);
                    channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), object2.getClass().getName(), (ChannelHandler)object2);
                }
            }
            channelHandlerContext.pipeline().remove(channelHandlerContext.name());
        }
        super.channelRead(channelHandlerContext, object);
    }
}

