/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.CombinedChannelDuplexHandler;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequestDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpServerUpgradeHandler;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpStatusClass;

public final class HttpServerCodec
extends CombinedChannelDuplexHandler<HttpRequestDecoder, HttpResponseEncoder>
implements HttpServerUpgradeHandler.SourceCodec {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();

    public HttpServerCodec() {
        this(4096, 8192, 8192);
    }

    public HttpServerCodec(int n, int n2, int n3) {
        this.init(new HttpServerRequestDecoder(n, n2, n3), new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int n, int n2, int n3, boolean bl) {
        this.init(new HttpServerRequestDecoder(n, n2, n3, bl), new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int n, int n2, int n3, boolean bl, int n4) {
        this.init(new HttpServerRequestDecoder(n, n2, n3, bl, n4), new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
        this.init(new HttpServerRequestDecoder(n, n2, n3, bl, n4, bl2), new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int n, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
        this.init(new HttpServerRequestDecoder(n, n2, n3, bl, n4, bl2, bl3), new HttpServerResponseEncoder());
    }

    @Override
    public void upgradeFrom(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.pipeline().remove(this);
    }

    private final class HttpServerResponseEncoder
    extends HttpResponseEncoder {
        private HttpMethod method;

        private HttpServerResponseEncoder() {
        }

        @Override
        protected void sanitizeHeadersBeforeEncode(HttpResponse httpResponse, boolean bl) {
            if (!bl && HttpMethod.CONNECT.equals(this.method) && httpResponse.status().codeClass() == HttpStatusClass.SUCCESS) {
                httpResponse.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
                return;
            }
            super.sanitizeHeadersBeforeEncode(httpResponse, bl);
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpResponse httpResponse) {
            this.method = (HttpMethod)HttpServerCodec.this.queue.poll();
            return HttpMethod.HEAD.equals(this.method) || super.isContentAlwaysEmpty(httpResponse);
        }
    }

    private final class HttpServerRequestDecoder
    extends HttpRequestDecoder {
        HttpServerRequestDecoder(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        HttpServerRequestDecoder(int n, int n2, int n3, boolean bl) {
            super(n, n2, n3, bl);
        }

        HttpServerRequestDecoder(int n, int n2, int n3, boolean bl, int n4) {
            super(n, n2, n3, bl, n4);
        }

        HttpServerRequestDecoder(int n, int n2, int n3, boolean bl, int n4, boolean bl2) {
            super(n, n2, n3, bl, n4, bl2);
        }

        HttpServerRequestDecoder(int n, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
            super(n, n2, n3, bl, n4, bl2, bl3);
        }

        @Override
        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            int n = list.size();
            super.decode(channelHandlerContext, byteBuf, list);
            int n2 = list.size();
            for (int i = n; i < n2; ++i) {
                Object object = list.get(i);
                if (!(object instanceof HttpRequest)) continue;
                HttpServerCodec.this.queue.add(((HttpRequest)object).method());
            }
        }
    }
}

