/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel;
import pro.gravit.repackage.io.netty.handler.codec.compression.Brotli;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliDecoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.SnappyFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibCodecFactory;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibWrapper;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean bl) {
        this.strict = bl;
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String string) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(string) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(string)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(string) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(string)) {
            ZlibWrapper zlibWrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(zlibWrapper));
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(string)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new BrotliDecoder());
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(string)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new SnappyFrameDecoder());
        }
        return null;
    }
}

