/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.address;

import java.net.SocketAddress;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.resolver.AddressResolver;
import pro.gravit.repackage.io.netty.resolver.AddressResolverGroup;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.FutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> addressResolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(addressResolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        AddressResolver<? extends SocketAddress> addressResolver = this.resolverGroup.getResolver(channelHandlerContext.executor());
        if (addressResolver.isSupported(socketAddress) && !addressResolver.isResolved(socketAddress)) {
            addressResolver.resolve(socketAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable throwable = future.cause();
                    if (throwable != null) {
                        channelPromise.setFailure(throwable);
                    } else {
                        channelHandlerContext.connect(future.getNow(), socketAddress2, channelPromise);
                    }
                    channelHandlerContext.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
            channelHandlerContext.pipeline().remove(this);
        }
    }
}

