/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.local;

import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import pro.gravit.repackage.io.netty.channel.AbstractServerChannel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.DefaultChannelConfig;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.PreferHeapByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.ServerChannelRecvByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.SingleThreadEventLoop;
import pro.gravit.repackage.io.netty.channel.local.LocalAddress;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel;
import pro.gravit.repackage.io.netty.channel.local.LocalChannelRegistry;
import pro.gravit.repackage.io.netty.util.concurrent.SingleThreadEventExecutor;

public class LocalServerChannel
extends AbstractServerChannel {
    private final ChannelConfig config = new DefaultChannelConfig(this, new ServerChannelRecvByteBufAllocator()){};
    private final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
    private final Runnable shutdownHook = new Runnable(){

        @Override
        public void run() {
            LocalServerChannel.this.unsafe().close(LocalServerChannel.this.unsafe().voidPromise());
        }
    };
    private volatile int state;
    private volatile LocalAddress localAddress;
    private volatile boolean acceptInProgress;

    public LocalServerChannel() {
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected void doRegister() throws Exception {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).addShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, socketAddress);
        this.state = 1;
    }

    @Override
    protected void doClose() throws Exception {
        if (this.state <= 1) {
            if (this.localAddress != null) {
                LocalChannelRegistry.unregister(this.localAddress);
                this.localAddress = null;
            }
            this.state = 2;
        }
    }

    @Override
    protected void doDeregister() throws Exception {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).removeShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBeginRead() throws Exception {
        if (this.acceptInProgress) {
            return;
        }
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.acceptInProgress = true;
            return;
        }
        this.readInbound();
    }

    LocalChannel serve(LocalChannel localChannel) {
        final LocalChannel localChannel2 = this.newLocalChannel(localChannel);
        if (this.eventLoop().inEventLoop()) {
            this.serve0(localChannel2);
        } else {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    LocalServerChannel.this.serve0(localChannel2);
                }
            });
        }
        return localChannel2;
    }

    private void readInbound() {
        Object object;
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.reset(this.config());
        ChannelPipeline channelPipeline = this.pipeline();
        while ((object = this.inboundBuffer.poll()) != null) {
            channelPipeline.fireChannelRead(object);
            if (handle.continueReading()) continue;
        }
        handle.readComplete();
        channelPipeline.fireChannelReadComplete();
    }

    protected LocalChannel newLocalChannel(LocalChannel localChannel) {
        return new LocalChannel(this, localChannel);
    }

    private void serve0(LocalChannel localChannel) {
        this.inboundBuffer.add(localChannel);
        if (this.acceptInProgress) {
            this.acceptInProgress = false;
            this.readInbound();
        }
    }
}

