/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufHolder;
import pro.gravit.repackage.io.netty.channel.FileRegion;
import pro.gravit.repackage.io.netty.channel.MessageSizeEstimator;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class DefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new DefaultMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    public DefaultMessageSizeEstimator(int n) {
        ObjectUtil.checkPositiveOrZero(n, "unknownSize");
        this.handle = new HandleImpl(n);
    }

    @Override
    public MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int n) {
            this.unknownSize = n;
        }

        @Override
        public int size(Object object) {
            if (object instanceof ByteBuf) {
                return ((ByteBuf)object).readableBytes();
            }
            if (object instanceof ByteBufHolder) {
                return ((ByteBufHolder)object).content().readableBytes();
            }
            if (object instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

