/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.util.concurrent.locks.ReentrantLock;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PoolSubpageMetric;

final class PoolSubpage<T>
implements PoolSubpageMetric {
    final PoolChunk<T> chunk;
    final int elemSize;
    private final int pageShifts;
    private final int runOffset;
    private final int runSize;
    private final long[] bitmap;
    private final int bitmapLength;
    private final int maxNumElems;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    private int nextAvail;
    private int numAvail;
    private final ReentrantLock lock;

    PoolSubpage() {
        this.chunk = null;
        this.lock = new ReentrantLock();
        this.pageShifts = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.runSize = -1;
        this.bitmap = null;
        this.bitmapLength = -1;
        this.maxNumElems = 0;
    }

    PoolSubpage(PoolSubpage<T> poolSubpage, PoolChunk<T> poolChunk, int n, int n2, int n3, int n4) {
        this.chunk = poolChunk;
        this.pageShifts = n;
        this.runOffset = n2;
        this.runSize = n3;
        this.elemSize = n4;
        this.doNotDestroy = true;
        this.maxNumElems = this.numAvail = n3 / n4;
        int n5 = this.maxNumElems >>> 6;
        if ((this.maxNumElems & 0x3F) != 0) {
            ++n5;
        }
        this.bitmapLength = n5;
        this.bitmap = new long[n5];
        this.nextAvail = 0;
        this.lock = null;
        this.addToPool(poolSubpage);
    }

    long allocate() {
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int n = this.getNextAvail();
        if (n < 0) {
            this.removeFromPool();
            throw new AssertionError((Object)("No next available bitmap index found (bitmapIdx = " + n + "), even though there are supposed to be (numAvail = " + this.numAvail + ") out of (maxNumElems = " + this.maxNumElems + ") available indexes."));
        }
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        assert ((this.bitmap[n2] >>> n3 & 1L) == 0L);
        int n4 = n2;
        this.bitmap[n4] = this.bitmap[n4] | 1L << n3;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle(n);
    }

    boolean free(PoolSubpage<T> poolSubpage, int n) {
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        assert ((this.bitmap[n2] >>> n3 & 1L) != 0L);
        int n4 = n2;
        this.bitmap[n4] = this.bitmap[n4] ^ 1L << n3;
        this.setNextAvail(n);
        if (this.numAvail++ == 0) {
            this.addToPool(poolSubpage);
            if (this.maxNumElems > 1) {
                return true;
            }
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> poolSubpage) {
        assert (this.prev == null && this.next == null);
        this.prev = poolSubpage;
        this.next = poolSubpage.next;
        this.next.prev = this;
        poolSubpage.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    private void setNextAvail(int n) {
        this.nextAvail = n;
    }

    private int getNextAvail() {
        int n = this.nextAvail;
        if (n >= 0) {
            this.nextAvail = -1;
            return n;
        }
        return this.findNextAvail();
    }

    private int findNextAvail() {
        for (int i = 0; i < this.bitmapLength; ++i) {
            long l = this.bitmap[i];
            if ((l ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i, l);
        }
        return -1;
    }

    private int findNextAvail0(int n, long l) {
        int n2 = n << 6;
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L) == 0L) {
                int n3 = n2 | i;
                if (n3 >= this.maxNumElems) break;
                return n3;
            }
            l >>>= 1;
        }
        return -1;
    }

    private long toHandle(int n) {
        int n2 = this.runSize >> this.pageShifts;
        return (long)this.runOffset << 49 | (long)n2 << 34 | 0x200000000L | 0x100000000L | (long)n;
    }

    public String toString() {
        int n;
        if (this.chunk == null) {
            n = 0;
        } else {
            boolean bl;
            this.chunk.arena.lock();
            try {
                bl = this.doNotDestroy;
                n = this.numAvail;
            }
            finally {
                this.chunk.arena.unlock();
            }
            if (!bl) {
                return "(" + this.runOffset + ": not in use)";
            }
        }
        return "(" + this.runOffset + ": " + (this.maxNumElems - n) + '/' + this.maxNumElems + ", offset: " + this.runOffset + ", length: " + this.runSize + ", elemSize: " + this.elemSize + ')';
    }

    @Override
    public int maxNumElements() {
        return this.maxNumElems;
    }

    @Override
    public int numAvailable() {
        if (this.chunk == null) {
            return 0;
        }
        this.chunk.arena.lock();
        try {
            int n = this.numAvail;
            return n;
        }
        finally {
            this.chunk.arena.unlock();
        }
    }

    @Override
    public int elementSize() {
        return this.elemSize;
    }

    @Override
    public int pageSize() {
        return 1 << this.pageShifts;
    }

    void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }
}

