/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.util.Arrays;

final class IntPriorityQueue {
    public static final int NO_VALUE = -1;
    private int[] array = new int[9];
    private int size;

    IntPriorityQueue() {
    }

    public void offer(int n) {
        if (n == -1) {
            throw new IllegalArgumentException("The NO_VALUE (-1) cannot be added to the queue.");
        }
        ++this.size;
        if (this.size == this.array.length) {
            this.array = Arrays.copyOf(this.array, 1 + (this.array.length - 1) * 2);
        }
        this.array[this.size] = n;
        this.lift(this.size);
    }

    public void remove(int n) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.array[i] != n) continue;
            this.array[i] = this.array[this.size--];
            this.lift(i);
            this.sink(i);
            return;
        }
    }

    public int peek() {
        if (this.size == 0) {
            return -1;
        }
        return this.array[1];
    }

    public int poll() {
        if (this.size == 0) {
            return -1;
        }
        int n = this.array[1];
        this.array[1] = this.array[this.size];
        this.array[this.size] = 0;
        --this.size;
        this.sink(1);
        return n;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void lift(int n) {
        int n2;
        while (n > 1 && this.subord(n2 = n >> 1, n)) {
            this.swap(n, n2);
            n = n2;
        }
    }

    private void sink(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.subord(n2, n2 + 1)) {
                ++n2;
            }
            if (!this.subord(n, n2)) break;
            this.swap(n, n2);
            n = n2;
        }
    }

    private boolean subord(int n, int n2) {
        return this.array[n] > this.array[n2];
    }

    private void swap(int n, int n2) {
        int n3 = this.array[n];
        this.array[n] = this.array[n2];
        this.array[n2] = n3;
    }
}

