/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.bootstrap;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.bootstrap.AbstractBootstrap;
import pro.gravit.repackage.io.netty.bootstrap.ServerBootstrapConfig;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelInitializer;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.channel.ServerChannel;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new ConcurrentHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;

    public ServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap(ServerBootstrap serverBootstrap) {
        super(serverBootstrap);
        this.childGroup = serverBootstrap.childGroup;
        this.childHandler = serverBootstrap.childHandler;
        Map<ChannelOption<?>, Object> map = serverBootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(serverBootstrap.childOptions);
        }
        this.childAttrs.putAll(serverBootstrap.childAttrs);
    }

    @Override
    public ServerBootstrap group(EventLoopGroup eventLoopGroup) {
        return this.group(eventLoopGroup, eventLoopGroup);
    }

    public ServerBootstrap group(EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2) {
        super.group(eventLoopGroup);
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = ObjectUtil.checkNotNull(eventLoopGroup2, "childGroup");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> channelOption, T t) {
        ObjectUtil.checkNotNull(channelOption, "childOption");
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            if (t == null) {
                this.childOptions.remove(channelOption);
            } else {
                this.childOptions.put(channelOption, t);
            }
        }
        return this;
    }

    public <T> ServerBootstrap childAttr(AttributeKey<T> attributeKey, T t) {
        ObjectUtil.checkNotNull(attributeKey, "childKey");
        if (t == null) {
            this.childAttrs.remove(attributeKey);
        } else {
            this.childAttrs.put(attributeKey, t);
        }
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler channelHandler) {
        this.childHandler = ObjectUtil.checkNotNull(channelHandler, "childHandler");
        return this;
    }

    @Override
    void init(Channel channel) {
        ServerBootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        ServerBootstrap.setAttributes(channel, this.newAttributesArray());
        ChannelPipeline channelPipeline = channel.pipeline();
        final EventLoopGroup eventLoopGroup = this.childGroup;
        final ChannelHandler channelHandler = this.childHandler;
        final Map.Entry[] entryArray = ServerBootstrap.newOptionsArray(this.childOptions);
        final Map.Entry[] entryArray2 = ServerBootstrap.newAttributesArray(this.childAttrs);
        channelPipeline.addLast(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(final Channel channel) {
                final ChannelPipeline channelPipeline = channel.pipeline();
                ChannelHandler channelHandler2 = ServerBootstrap.this.config.handler();
                if (channelHandler2 != null) {
                    channelPipeline.addLast(channelHandler2);
                }
                channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        channelPipeline.addLast(new ServerBootstrapAcceptor(channel, eventLoopGroup, channelHandler, entryArray, entryArray2));
                    }
                });
            }
        });
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> childOptions() {
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            return ServerBootstrap.copiedMap(this.childOptions);
        }
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    private static class ServerBootstrapAcceptor
    extends ChannelInboundHandlerAdapter {
        private final EventLoopGroup childGroup;
        private final ChannelHandler childHandler;
        private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
        private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;
        private final Runnable enableAutoReadTask;

        ServerBootstrapAcceptor(final Channel channel, EventLoopGroup eventLoopGroup, ChannelHandler channelHandler, Map.Entry<ChannelOption<?>, Object>[] entryArray, Map.Entry<AttributeKey<?>, Object>[] entryArray2) {
            this.childGroup = eventLoopGroup;
            this.childHandler = channelHandler;
            this.childOptions = entryArray;
            this.childAttrs = entryArray2;
            this.enableAutoReadTask = new Runnable(){

                @Override
                public void run() {
                    channel.config().setAutoRead(true);
                }
            };
        }

        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            final Channel channel = (Channel)object;
            channel.pipeline().addLast(this.childHandler);
            AbstractBootstrap.setChannelOptions(channel, this.childOptions, logger);
            AbstractBootstrap.setAttributes(channel, this.childAttrs);
            try {
                this.childGroup.register(channel).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (!channelFuture.isSuccess()) {
                            ServerBootstrapAcceptor.forceClose(channel, channelFuture.cause());
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                ServerBootstrapAcceptor.forceClose(channel, throwable);
            }
        }

        private static void forceClose(Channel channel, Throwable throwable) {
            channel.unsafe().closeForcibly();
            logger.warn("Failed to register an accepted channel: {}", (Object)channel, (Object)throwable);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            ChannelConfig channelConfig = channelHandlerContext.channel().config();
            if (channelConfig.isAutoRead()) {
                channelConfig.setAutoRead(false);
                channelHandlerContext.channel().eventLoop().schedule(this.enableAutoReadTask, 1L, TimeUnit.SECONDS);
            }
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }
}

