/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.LogHelper;

public class OfflineRequestService
implements RequestService {
    private final HashSet<RequestService.EventHandler> eventHandlers = new HashSet();
    private final Map<Class<?>, RequestProcessor<?, ?>> processors = new ConcurrentHashMap();

    @Override
    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) {
        RequestProcessor<?, ?> requestProcessor = this.processors.get(request.getClass());
        CompletableFuture completableFuture = new CompletableFuture();
        if (requestProcessor == null) {
            completableFuture.completeExceptionally(new RequestException(String.format("Offline mode not support '%s'", request.getType())));
            return completableFuture;
        }
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev("Request %s: %s", request.getType(), Launcher.gsonManager.gson.toJson(request));
        }
        try {
            Object obj = requestProcessor.process(request);
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev("Response %s: %s", obj.getType(), Launcher.gsonManager.gson.toJson(obj));
            }
            completableFuture.complete(obj);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RequestException) {
                completableFuture.completeExceptionally(throwable);
            }
            completableFuture.completeExceptionally(new RequestException(throwable));
        }
        return completableFuture;
    }

    @Override
    public void open() {
    }

    @Override
    public void registerEventHandler(RequestService.EventHandler eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    @Override
    public void unregisterEventHandler(RequestService.EventHandler eventHandler) {
        this.eventHandlers.remove(eventHandler);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public <T extends WebSocketEvent, V extends WebSocketRequest> void registerRequestProcessor(Class<V> clazz, RequestProcessor<T, V> requestProcessor) {
        this.processors.put(clazz, requestProcessor);
    }

    public <T extends WebSocketEvent> void unregisterRequestProcessor(Class<Request<T>> clazz) {
        this.processors.remove(clazz);
    }

    public static interface RequestProcessor<T extends WebSocketEvent, V extends WebSocketRequest> {
        public T process(V var1) throws RequestException;
    }
}

