/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.CurrentUserRequestEvent;
import pro.gravit.launcher.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.events.request.RestoreRequestEvent;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.request.auth.RestoreRequest;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.TypeSerializeInterface;
import pro.gravit.utils.helper.LogHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    private static final List<ExtendedTokenCallback> extendedTokenCallbacks = new ArrayList<ExtendedTokenCallback>(4);
    private static final List<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>> oauthChangeHandlers = new ArrayList<BiConsumer<String, AuthRequestEvent.OAuthRequestEvent>>(4);
    private static volatile RequestService requestService;
    private static volatile AuthRequestEvent.OAuthRequestEvent oauth;
    private static volatile Map<String, ExtendedToken> extendedTokens;
    private static volatile String authId;
    private static volatile long tokenExpiredTime;
    private static volatile ScheduledExecutorService executorService;
    private static volatile boolean autoRefreshRunning;
    @LauncherNetworkAPI
    public final UUID requestUUID = UUID.randomUUID();
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static synchronized void startAutoRefresh() {
        if (!autoRefreshRunning) {
            if (executorService == null) {
                executorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
                    Thread thread = new Thread(runnable);
                    thread.setName("AutoRefresh thread");
                    thread.setDaemon(true);
                    return thread;
                });
            }
            executorService.scheduleAtFixedRate(() -> {
                try {
                    Request.restore(false, true, false);
                }
                catch (Exception exception) {
                    LogHelper.error(exception);
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            autoRefreshRunning = true;
        }
    }

    public static RequestService getRequestService() {
        return requestService;
    }

    public static void setRequestService(RequestService requestService) {
        Request.requestService = requestService;
    }

    public static boolean isAvailable() {
        return requestService != null;
    }

    public static void setOAuth(String string, AuthRequestEvent.OAuthRequestEvent oAuthRequestEvent) {
        oauth = oAuthRequestEvent;
        authId = string;
        tokenExpiredTime = oauth != null && Request.oauth.expire != 0L ? System.currentTimeMillis() + Request.oauth.expire : 0L;
        for (BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> biConsumer : oauthChangeHandlers) {
            biConsumer.accept(string, oAuthRequestEvent);
        }
    }

    public static AuthRequestEvent.OAuthRequestEvent getOAuth() {
        return oauth;
    }

    public static String getAuthId() {
        return authId;
    }

    public static Map<String, ExtendedToken> getExtendedTokens() {
        if (extendedTokens != null) {
            return Collections.unmodifiableMap(extendedTokens);
        }
        return null;
    }

    public static Map<String, String> getStringExtendedTokens() {
        if (extendedTokens != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, ExtendedToken> entry : extendedTokens.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().token);
            }
            return hashMap;
        }
        return null;
    }

    public static void clearExtendedTokens() {
        if (extendedTokens != null) {
            extendedTokens.clear();
        }
    }

    public static void addExtendedToken(String string, ExtendedToken extendedToken) {
        if (extendedTokens == null) {
            extendedTokens = new ConcurrentHashMap<String, ExtendedToken>();
        }
        extendedTokens.put(string, extendedToken);
    }

    public static void addAllExtendedToken(Map<String, ExtendedToken> map) {
        if (extendedTokens == null) {
            extendedTokens = new ConcurrentHashMap<String, ExtendedToken>();
        }
        extendedTokens.putAll(map);
    }

    public static void setOAuth(String string, AuthRequestEvent.OAuthRequestEvent oAuthRequestEvent, long l) {
        oauth = oAuthRequestEvent;
        authId = string;
        tokenExpiredTime = l;
    }

    public static boolean isTokenExpired() {
        if (oauth == null) {
            return true;
        }
        if (tokenExpiredTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > tokenExpiredTime;
    }

    public static long getTokenExpiredTime() {
        return tokenExpiredTime;
    }

    public static String getAccessToken() {
        return oauth == null ? null : Request.oauth.accessToken;
    }

    public static String getRefreshToken() {
        return oauth == null ? null : Request.oauth.refreshToken;
    }

    public static void reconnect() throws Exception {
        Request.getRequestService().open();
        Request.restore();
    }

    public static RequestRestoreReport restore() throws Exception {
        return Request.restore(false, false, false);
    }

    private static synchronized Map<String, String> getExpiredExtendedTokens() {
        if (extendedTokens == null) {
            return new HashMap<String, String>();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, ExtendedToken> entry : extendedTokens.entrySet()) {
            if (entry.getValue().expire == 0L || entry.getValue().expire >= System.currentTimeMillis()) continue;
            hashSet.add(entry.getKey());
        }
        if (hashSet.isEmpty()) {
            return new HashMap<String, String>();
        }
        return Request.makeNewTokens(hashSet);
    }

    public static synchronized RequestRestoreReport restore(boolean bl, boolean bl2, boolean bl3) throws Exception {
        Object object;
        TypeSerializeInterface typeSerializeInterface;
        boolean bl4 = false;
        if (oauth != null && (Request.isTokenExpired() || Request.oauth.accessToken == null)) {
            if (bl3) {
                oauth = null;
            } else {
                typeSerializeInterface = new RefreshTokenRequest(authId, Request.oauth.refreshToken);
                object = (RefreshTokenRequestEvent)typeSerializeInterface.request();
                Request.setOAuth(authId, ((RefreshTokenRequestEvent)object).oauth);
                bl4 = true;
            }
        }
        RestoreRequest restoreRequest = oauth != null ? new RestoreRequest(authId, Request.oauth.accessToken, bl2 ? Request.getExpiredExtendedTokens() : Request.getStringExtendedTokens(), bl) : new RestoreRequest(authId, null, bl2 ? Request.getExpiredExtendedTokens() : Request.getStringExtendedTokens(), false);
        if (bl2 && (restoreRequest.extended == null || restoreRequest.extended.isEmpty())) {
            return new RequestRestoreReport(bl4, null, null);
        }
        typeSerializeInterface = (RestoreRequestEvent)restoreRequest.request();
        object = null;
        if (((RestoreRequestEvent)typeSerializeInterface).invalidTokens != null && ((RestoreRequestEvent)typeSerializeInterface).invalidTokens.size() > 0) {
            Map<String, String> map = Request.makeNewTokens(((RestoreRequestEvent)typeSerializeInterface).invalidTokens);
            if (!map.isEmpty()) {
                restoreRequest = new RestoreRequest(authId, null, map, false);
                typeSerializeInterface = (RestoreRequestEvent)restoreRequest.request();
                if (((RestoreRequestEvent)typeSerializeInterface).invalidTokens != null && ((RestoreRequestEvent)typeSerializeInterface).invalidTokens.size() > 0) {
                    LogHelper.warning("Tokens %s not restored", String.join((CharSequence)",", ((RestoreRequestEvent)typeSerializeInterface).invalidTokens));
                }
            }
            object = ((RestoreRequestEvent)typeSerializeInterface).invalidTokens;
        }
        return new RequestRestoreReport(bl4, (List<String>)object, ((RestoreRequestEvent)typeSerializeInterface).userInfo);
    }

    private static synchronized Map<String, String> makeNewTokens(Collection<String> collection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ExtendedTokenCallback extendedTokenCallback : extendedTokenCallbacks) {
            for (String string : collection) {
                ExtendedToken extendedToken = extendedTokenCallback.tryGetNewToken(string);
                if (extendedToken == null) continue;
                hashMap.put(string, extendedToken.token);
                Request.addExtendedToken(string, extendedToken);
            }
        }
        return hashMap;
    }

    public static void requestError(String string) throws RequestException {
        throw new RequestException(string);
    }

    public void addExtendedTokenCallback(ExtendedTokenCallback extendedTokenCallback) {
        extendedTokenCallbacks.add(extendedTokenCallback);
    }

    public void removeExtendedTokenCallback(ExtendedTokenCallback extendedTokenCallback) {
        extendedTokenCallbacks.remove(extendedTokenCallback);
    }

    public void addOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> biConsumer) {
        oauthChangeHandlers.add(biConsumer);
    }

    public void removeOAuthChangeHandler(BiConsumer<String, AuthRequestEvent.OAuthRequestEvent> biConsumer) {
        oauthChangeHandlers.remove(biConsumer);
    }

    public R request() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (!Request.isAvailable()) {
            throw new RequestException("RequestService not initialized");
        }
        return this.requestDo(requestService);
    }

    @Deprecated
    public R request(StdWebSocketService stdWebSocketService) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(stdWebSocketService);
    }

    public R request(RequestService requestService) throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(requestService);
    }

    protected R requestDo(RequestService requestService) throws Exception {
        return (R)requestService.requestSync(this);
    }

    public static class ExtendedToken {
        public final String token;
        public final long expire;

        public ExtendedToken(String string, long l) {
            this.token = string;
            long l2 = System.currentTimeMillis();
            this.expire = l < l2 / 2L ? l2 + l : l;
        }
    }

    public static class RequestRestoreReport {
        public final boolean refreshed;
        public final List<String> invalidExtendedTokens;
        public final CurrentUserRequestEvent.UserInfo userInfo;

        public RequestRestoreReport(boolean bl, List<String> list, CurrentUserRequestEvent.UserInfo userInfo) {
            this.refreshed = bl;
            this.invalidExtendedTokens = list;
            this.userInfo = userInfo;
        }
    }

    public static interface ExtendedTokenCallback {
        public ExtendedToken tryGetNewToken(String var1);
    }
}

