/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;
import pro.gravit.utils.launch.LaunchOptions;

public final class ClientProfile
implements Comparable<ClientProfile> {
    private static final FileNameMatcher ASSET_MATCHER = new FileNameMatcher(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @LauncherNetworkAPI
    private String title;
    @LauncherNetworkAPI
    private UUID uuid;
    @LauncherNetworkAPI
    private Version version;
    @LauncherNetworkAPI
    private String info;
    @LauncherNetworkAPI
    private String dir;
    @LauncherNetworkAPI
    private int sortIndex;
    @LauncherNetworkAPI
    private String assetIndex;
    @LauncherNetworkAPI
    private String assetDir;
    @LauncherNetworkAPI
    private List<String> update;
    @LauncherNetworkAPI
    private List<String> updateExclusions;
    @LauncherNetworkAPI
    private List<String> updateShared;
    @LauncherNetworkAPI
    private List<String> updateVerify;
    @LauncherNetworkAPI
    private Set<OptionalFile> updateOptional;
    @LauncherNetworkAPI
    private List<String> jvmArgs;
    @LauncherNetworkAPI
    private List<String> classPath;
    @LauncherNetworkAPI
    private List<String> modulePath = new ArrayList<String>();
    @LauncherNetworkAPI
    private List<String> modules = new ArrayList<String>();
    @LauncherNetworkAPI
    private List<String> altClassPath;
    @LauncherNetworkAPI
    private List<String> clientArgs;
    @LauncherNetworkAPI
    private List<String> compatClasses;
    @LauncherNetworkAPI
    private Map<String, String> properties;
    @LauncherNetworkAPI
    private List<ServerProfile> servers;
    @LauncherNetworkAPI
    private ClassLoaderConfig classLoaderConfig;
    @LauncherNetworkAPI
    private List<CompatibilityFlags> flags;
    @LauncherNetworkAPI
    private int recommendJavaVersion = 8;
    @LauncherNetworkAPI
    private int minJavaVersion = 8;
    @LauncherNetworkAPI
    private int maxJavaVersion = 999;
    @LauncherNetworkAPI
    private ProfileDefaultSettings settings = new ProfileDefaultSettings();
    @LauncherNetworkAPI
    private boolean limited;
    @LauncherNetworkAPI
    private String mainClass;
    @LauncherNetworkAPI
    private String mainModule;
    @LauncherNetworkAPI
    private LaunchOptions.ModuleConf moduleConf;

    public ClientProfile() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateShared = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.modulePath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ServerProfile>(1);
        this.classLoaderConfig = ClassLoaderConfig.LAUNCHER;
        this.flags = new ArrayList<CompatibilityFlags>();
    }

    public ClientProfile(List<String> list, List<String> list2, List<String> list3, List<String> list4, Set<OptionalFile> set, List<String> list5, List<String> list6, List<String> list7, List<String> list8, List<String> list9, List<String> list10, List<String> list11, Map<String, String> map, List<ServerProfile> list12, ClassLoaderConfig classLoaderConfig, List<CompatibilityFlags> list13, Version version, String string, String string2, String string3, int n, int n2, int n3, ProfileDefaultSettings profileDefaultSettings, int n4, UUID uUID, String string4, String string5, String string6) {
        this.update = list;
        this.updateExclusions = list2;
        this.updateShared = list3;
        this.updateVerify = list4;
        this.updateOptional = set;
        this.jvmArgs = list5;
        this.classPath = list6;
        this.modulePath = list7;
        this.modules = list8;
        this.altClassPath = list9;
        this.clientArgs = list10;
        this.compatClasses = list11;
        this.properties = map;
        this.servers = list12;
        this.classLoaderConfig = classLoaderConfig;
        this.version = version;
        this.assetIndex = string;
        this.dir = string2;
        this.assetDir = string3;
        this.recommendJavaVersion = n;
        this.minJavaVersion = n2;
        this.maxJavaVersion = n3;
        this.settings = profileDefaultSettings;
        this.sortIndex = n4;
        this.uuid = uUID;
        this.title = string4;
        this.info = string5;
        this.mainClass = string6;
        this.flags = list13;
    }

    public ServerProfile getDefaultServerProfile() {
        for (ServerProfile serverProfile : this.servers) {
            if (!serverProfile.isDefault) continue;
            return serverProfile;
        }
        return null;
    }

    @Override
    public int compareTo(ClientProfile clientProfile) {
        return Integer.compare(this.getSortIndex(), clientProfile.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public FileNameMatcher getAssetUpdateMatcher() {
        return this.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0 ? ASSET_MATCHER : null;
    }

    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    public List<String> getModulePath() {
        return Collections.unmodifiableList(this.modulePath);
    }

    public List<String> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public String[] getAlternativeClassPath() {
        return this.altClassPath.toArray(new String[0]);
    }

    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public List<String> getUpdateExclusions() {
        return Collections.unmodifiableList(this.updateExclusions);
    }

    public FileNameMatcher getClientUpdateMatcher() {
        String[] stringArray = this.update.toArray(new String[0]);
        String[] stringArray2 = this.updateVerify.toArray(new String[0]);
        List<String> list = this.updateExclusions;
        String[] stringArray3 = list.toArray(new String[0]);
        return new FileNameMatcher(stringArray, stringArray2, stringArray3);
    }

    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainModule() {
        return this.mainModule;
    }

    public LaunchOptions.ModuleConf getModuleConf() {
        return this.moduleConf;
    }

    public List<ServerProfile> getServers() {
        return this.servers;
    }

    public String getServerAddress() {
        ServerProfile serverProfile = this.getDefaultServerProfile();
        return serverProfile == null ? "localhost" : serverProfile.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public int getRecommendJavaVersion() {
        return this.recommendJavaVersion;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public int getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public ProfileDefaultSettings getSettings() {
        return this.settings;
    }

    public void updateOptionalGraph() {
        for (OptionalFile optionalFile : this.updateOptional) {
            int n;
            if (optionalFile.dependenciesFile != null) {
                optionalFile.dependencies = new OptionalFile[optionalFile.dependenciesFile.length];
                for (n = 0; n < optionalFile.dependenciesFile.length; ++n) {
                    optionalFile.dependencies[n] = this.getOptionalFile(optionalFile.dependenciesFile[n].name);
                }
            }
            if (optionalFile.conflictFile != null) {
                optionalFile.conflict = new OptionalFile[optionalFile.conflictFile.length];
                for (n = 0; n < optionalFile.conflictFile.length; ++n) {
                    optionalFile.conflict[n] = this.getOptionalFile(optionalFile.conflictFile[n].name);
                }
            }
            if (optionalFile.groupFile == null) continue;
            optionalFile.group = new OptionalFile[optionalFile.groupFile.length];
            for (n = 0; n < optionalFile.groupFile.length; ++n) {
                optionalFile.group[n] = this.getOptionalFile(optionalFile.groupFile[n].name);
            }
        }
    }

    public OptionalFile getOptionalFile(String string) {
        for (OptionalFile optionalFile : this.updateOptional) {
            if (!optionalFile.name.equals(string)) continue;
            return optionalFile;
        }
        return null;
    }

    public Collection<String> getShared() {
        return this.updateShared;
    }

    public int getServerPort() {
        ServerProfile serverProfile = this.getDefaultServerProfile();
        return serverProfile == null ? 25565 : serverProfile.serverPort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Deprecated
    public boolean isUpdateFastCheck() {
        return true;
    }

    public String toString() {
        return String.format("%s (%s)", this.title, this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public boolean hasFlag(CompatibilityFlags compatibilityFlags) {
        return this.flags.contains((Object)compatibilityFlags);
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName(this.getAssetIndex());
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Profile title can't be empty");
        VerifyHelper.verify(this.getInfo(), VerifyHelper.NOT_EMPTY, "Profile info can't be empty");
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Main class can't be empty");
        if (this.getUUID() == null) {
            throw new IllegalArgumentException("Profile UUID can't be null");
        }
        for (String object : this.update) {
            if (object != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String string : this.updateVerify) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String string : this.updateExclusions) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String string : this.classPath) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String string : this.jvmArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String string : this.clientArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (String string : this.compatClasses) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in compatClasses");
        }
        for (OptionalFile optionalFile : this.updateOptional) {
            if (optionalFile == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (optionalFile.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (optionalFile.conflictFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", optionalFile.name));
                }
            }
            if (optionalFile.dependenciesFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.dependenciesFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", optionalFile.name));
                }
            }
            if (optionalFile.groupFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.groupFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.groupFile", optionalFile.name));
                }
            }
            if (optionalFile.triggersList == null) continue;
            for (OptionalTrigger optionalTrigger : optionalFile.triggersList) {
                if (optionalTrigger != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.triggers", optionalFile.name));
            }
        }
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public void putProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public boolean containsProperty(String string) {
        return this.properties.containsKey(string);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<String> getCompatClasses() {
        return Collections.unmodifiableList(this.compatClasses);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientProfile clientProfile = (ClientProfile)object;
        return Objects.equals(this.uuid, clientProfile.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClassLoaderConfig classLoaderConfig) {
        this.classLoaderConfig = classLoaderConfig;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public List<CompatibilityFlags> getFlags() {
        return this.flags;
    }

    public static class ProfileDefaultSettings {
        public int ram;
        public boolean autoEnter;
        public boolean fullScreen;
    }

    public static enum ClassLoaderConfig {
        AGENT,
        LAUNCHER,
        MODULE,
        SYSTEM_ARGS;

    }

    public static class Version
    implements Comparable<Version> {
        private final long[] data;
        private final String original;
        private final boolean isObjectSerialized;

        public static Version of(String string2) {
            String string3 = string2.replaceAll("[^.0-9]", ".");
            String[] stringArray = string3.split("\\.");
            return new Version(Arrays.stream(stringArray).filter(string -> !string.isEmpty()).mapToLong(Long::parseLong).toArray(), string2);
        }

        private Version(long[] lArray, String string) {
            this.data = lArray;
            this.original = string;
            this.isObjectSerialized = false;
        }

        public Version(long[] lArray, String string, boolean bl) {
            this.data = lArray;
            this.original = string;
            this.isObjectSerialized = bl;
        }

        @Override
        public int compareTo(Version version) {
            int n = 0;
            if (this.data.length == version.data.length) {
                for (int i = 0; i < this.data.length; ++i) {
                    n = Long.compare(this.data[i], version.data[i]);
                    if (n == 0) continue;
                    return n;
                }
            } else if (this.data.length < version.data.length) {
                int n2;
                for (n2 = 0; n2 < this.data.length; ++n2) {
                    n = Long.compare(this.data[n2], version.data[n2]);
                    if (n == 0) continue;
                    return n;
                }
                for (n2 = this.data.length; n2 < version.data.length; ++n2) {
                    if (version.data[n2] <= 0L) continue;
                    return -1;
                }
            } else {
                int n3;
                for (n3 = 0; n3 < version.data.length; ++n3) {
                    n = Long.compare(this.data[n3], version.data[n3]);
                    if (n == 0) continue;
                    return n;
                }
                for (n3 = version.data.length; n3 < this.data.length; ++n3) {
                    if (this.data[n3] <= 0L) continue;
                    return 1;
                }
            }
            return n;
        }

        public String toCleanString() {
            return Version.join(this.data);
        }

        private static String join(long[] lArray) {
            return String.join((CharSequence)".", (CharSequence[])Arrays.stream(lArray).mapToObj(String::valueOf).toArray(String[]::new));
        }

        public String toString() {
            return this.original;
        }

        public static class GsonSerializer
        implements JsonSerializer<Version>,
        JsonDeserializer<Version> {
            @Override
            public Version deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                if (jsonElement.isJsonObject()) {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String string = jsonObject.get("name").getAsString();
                    long[] lArray = (long[])jsonDeserializationContext.deserialize(jsonObject.get("data"), (Type)((Object)long[].class));
                    return new Version(lArray, string, true);
                }
                if (jsonElement.isJsonArray()) {
                    long[] lArray = (long[])jsonDeserializationContext.deserialize(jsonElement, (Type)((Object)long[].class));
                    return new Version(lArray, Version.join(lArray), false);
                }
                return Version.of(jsonElement.getAsString());
            }

            @Override
            public JsonElement serialize(Version version, Type type, JsonSerializationContext jsonSerializationContext) {
                if (version.isObjectSerialized) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add("name", new JsonPrimitive(version.original));
                    JsonArray jsonArray = new JsonArray();
                    for (long l : version.data) {
                        jsonArray.add(l);
                    }
                    jsonObject.add("data", jsonArray);
                    return jsonObject;
                }
                return new JsonPrimitive(version.toString());
            }
        }
    }

    public static class ServerProfile {
        public String name;
        public String serverAddress;
        public int serverPort;
        public boolean isDefault = true;
        public int protocol = -1;
        public boolean socketPing = true;

        public ServerProfile() {
        }

        public ServerProfile(String string, String string2, int n) {
            this.name = string;
            this.serverAddress = string2;
            this.serverPort = n;
        }

        public ServerProfile(String string, String string2, int n, boolean bl) {
            this.name = string;
            this.serverAddress = string2;
            this.serverPort = n;
            this.isDefault = bl;
        }

        public InetSocketAddress toSocketAddress() {
            return InetSocketAddress.createUnresolved(this.serverAddress, this.serverPort);
        }
    }

    public static enum CompatibilityFlags {
        LEGACY_NATIVES_DIR,
        CLASS_CONTROL_API,
        ENABLE_HACKS;

    }
}

