/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.console;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.LogHelper;

public class ModulesCommand
extends Command {
    @Override
    public String getArgsDescription() {
        return "[]";
    }

    @Override
    public String getUsageDescription() {
        return "show modules";
    }

    @Override
    public void invoke(String ... stringArray) {
        for (LauncherModule launcherModule : LauncherEngine.modulesManager.getModules()) {
            LauncherModuleInfo launcherModuleInfo = launcherModule.getModuleInfo();
            LauncherTrustManager.CheckClassResult checkClassResult = launcherModule.getCheckResult();
            if (!ConsoleManager.isConsoleUnlock) {
                LogHelper.info("[MODULE] %s v: %s", launcherModuleInfo.name, launcherModuleInfo.version.getVersionString());
                continue;
            }
            LogHelper.info("[MODULE] %s v: %s p: %d deps: %s sig: %s", launcherModuleInfo.name, launcherModuleInfo.version.getVersionString(), launcherModuleInfo.priority, Arrays.toString(launcherModuleInfo.dependencies), checkClassResult == null ? "null" : checkClassResult.type);
            this.printCheckStatusInfo(checkClassResult);
        }
    }

    private void printCheckStatusInfo(LauncherTrustManager.CheckClassResult checkClassResult) {
        X509Certificate x509Certificate;
        if (checkClassResult != null && checkClassResult.endCertificate != null) {
            x509Certificate = checkClassResult.endCertificate;
            LogHelper.info("[MODULE CERT] Module signer: %s", x509Certificate.getSubjectX500Principal().getName());
        }
        if (checkClassResult != null && checkClassResult.rootCertificate != null) {
            x509Certificate = checkClassResult.rootCertificate;
            LogHelper.info("[MODULE CERT] Module signer CA: %s", x509Certificate.getSubjectX500Principal().getName());
        }
    }
}

