/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.servermenu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.ServerPinger;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButton;
import pro.gravit.launcher.client.gui.utils.JavaFxUtils;
import pro.gravit.launcher.events.request.AssetUploadInfoRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.cabinet.AssetUploadInfoRequest;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerMenuScene
extends AbstractScene {
    private ImageView avatar;
    private List<ClientProfile> lastProfiles;
    private Image originalAvatarImage;

    public ServerMenuScene(JavaFXApplication javaFXApplication) {
        super("scenes/servermenu/servermenu.fxml", javaFXApplication);
    }

    @Override
    public void doInit() {
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(imageView -> {
            try {
                JavaFxUtils.setStaticRadius(imageView, 8.0);
                imageView.setImage(this.originalAvatarImage);
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        scrollPane.setOnScroll(scrollEvent -> {
            double d = scrollEvent.getDeltaY() / scrollPane.getWidth();
            scrollPane.setHvalue(scrollPane.getHvalue() - d);
        });
        this.reset();
        this.isResetOnShow = true;
    }

    public static ServerButton getServerButton(JavaFXApplication javaFXApplication, ClientProfile clientProfile) {
        return new ServerButton(javaFXApplication, clientProfile);
    }

    @Override
    public void reset() {
        ClientProfile clientProfile2;
        if (this.lastProfiles == this.application.profilesService.getProfiles()) {
            return;
        }
        this.lastProfiles = this.application.profilesService.getProfiles();
        LinkedHashMap<ClientProfile, ServerButtonCache> linkedHashMap = new LinkedHashMap<ClientProfile, ServerButtonCache>();
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(label -> label.setText(this.application.authService.getUsername()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#role").ifPresent(label -> label.setText(this.application.authService.getMainRole()));
        this.avatar.setImage(this.originalAvatarImage);
        ArrayList<ClientProfile> arrayList = new ArrayList<ClientProfile>(this.lastProfiles);
        arrayList.sort(Comparator.comparingInt(ClientProfile::getSortIndex).thenComparing(ClientProfile::getTitle));
        int n = 0;
        for (ClientProfile clientProfile2 : arrayList) {
            ServerButtonCache serverButtonCache = new ServerButtonCache();
            serverButtonCache.serverButton = ServerMenuScene.getServerButton(this.application, clientProfile2);
            serverButtonCache.position = n++;
            linkedHashMap.put(clientProfile2, serverButtonCache);
        }
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        clientProfile2 = (HBox)scrollPane.getContent();
        clientProfile2.setSpacing(20.0);
        clientProfile2.getChildren().clear();
        this.application.pingService.clear();
        linkedHashMap.forEach((arg_0, arg_1) -> this.lambda$reset$5((HBox)clientProfile2, arg_0, arg_1));
        CommonHelper.newThread("ServerPinger", true, () -> {
            for (ClientProfile clientProfile : this.lastProfiles) {
                for (ClientProfile.ServerProfile serverProfile : clientProfile.getServers()) {
                    if (!serverProfile.socketPing || serverProfile.serverAddress == null) continue;
                    try {
                        ServerPinger serverPinger = new ServerPinger(serverProfile, clientProfile.getVersion());
                        ServerPinger.Result result = serverPinger.ping();
                        this.contextHelper.runInFxThread(() -> this.application.pingService.addReport(serverProfile.name, result));
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
        this.resetAvatar();
        if (this.application.authService.isFeatureAvailable("assetupload")) {
            LookupHelper.lookupIfPossible((Node)this.layout, "#customization").ifPresent(button -> {
                button.setVisible(true);
                button.setOnAction(actionEvent2 -> this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.uploadassetinfo"), new AssetUploadInfoRequest(), assetUploadInfoRequestEvent -> this.contextHelper.runInFxThread(() -> this.showOverlay(this.application.gui.uploadAssetOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.application.gui.uploadAssetOverlay.onAssetUploadInfo((AssetUploadInfoRequestEvent)assetUploadInfoRequestEvent)))), this::errorHandle, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {})));
            });
        }
    }

    public void resetAvatar() {
        if (this.avatar == null) {
            return;
        }
        JavaFxUtils.putAvatarToImageView(this.application, this.application.authService.getUsername(), this.avatar);
    }

    @Override
    public String getName() {
        return "serverMenu";
    }

    private void changeServer(ClientProfile clientProfile) {
        this.application.profilesService.setProfile(clientProfile);
        this.application.runtimeSettings.lastProfile = clientProfile.getUUID();
    }

    private /* synthetic */ void lambda$reset$5(HBox hBox, ClientProfile clientProfile, ServerButtonCache serverButtonCache) {
        EventHandler eventHandler = mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            this.changeServer(clientProfile);
            try {
                this.switchScene(this.application.gui.serverInfoScene);
                this.application.gui.serverInfoScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        };
        serverButtonCache.serverButton.addTo((Pane)hBox, serverButtonCache.position);
        serverButtonCache.serverButton.setOnMouseClicked((EventHandler<? super MouseEvent>)eventHandler);
    }

    static class ServerButtonCache {
        public ServerButton serverButton;
        public int position;

        ServerButtonCache() {
        }
    }
}

