/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.options;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButton;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalView;

public class OptionsScene
extends AbstractScene {
    private TabPane tabPane;
    private final Map<String, Tab> tabs = new HashMap<String, Tab>();
    private OptionalView optionalView;
    private final Map<OptionalFile, Consumer<Boolean>> watchers = new HashMap<OptionalFile, Consumer<Boolean>>();

    public OptionsScene(JavaFXApplication javaFXApplication) {
        super("scenes/options/options.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.tabPane = (TabPane)LookupHelper.lookup((Node)this.layout, "#tabPane");
    }

    @Override
    public void reset() {
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        ClientProfile clientProfile = this.application.profilesService.getProfile();
        ServerButton serverButton = ServerMenuScene.getServerButton(this.application, clientProfile);
        serverButton.addTo(pane);
        serverButton.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                this.application.profilesService.setOptionalView(clientProfile, this.optionalView);
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButton.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            this.tabPane.getTabs().clear();
            this.tabs.clear();
            this.application.profilesService.setOptionalView(clientProfile, new OptionalView(clientProfile));
            this.addProfileOptionals(this.application.profilesService.getOptionalView());
        }));
        this.tabPane.getTabs().clear();
        this.tabs.clear();
        LookupHelper.lookupIfPossible((Node)this.header, "#back").ifPresent(button -> button.setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.addProfileOptionals(this.application.profilesService.getOptionalView());
    }

    @Override
    public String getName() {
        return "options";
    }

    private void callWatcher(OptionalFile optionalFile, Boolean bl) {
        for (Map.Entry<OptionalFile, Consumer<Boolean>> entry : this.watchers.entrySet()) {
            if (entry.getKey() != optionalFile) continue;
            entry.getValue().accept(bl);
            break;
        }
    }

    public void addProfileOptionals(OptionalView optionalView) {
        this.optionalView = new OptionalView(optionalView);
        this.watchers.clear();
        for (OptionalFile optionalFile : this.optionalView.all) {
            if (!optionalFile.visible) continue;
            List<String> list = optionalFile.dependencies == null ? List.of() : Arrays.stream(optionalFile.dependencies).map(OptionalFile::getName).toList();
            Consumer<Boolean> consumer = this.add(optionalFile.category == null ? "GLOBAL" : optionalFile.category, optionalFile.name, optionalFile.info, this.optionalView.enabled.contains(optionalFile), optionalFile.subTreeLevel, bl -> {
                if (bl.booleanValue()) {
                    this.optionalView.enable(optionalFile, true, this::callWatcher);
                } else {
                    this.optionalView.disable(optionalFile, this::callWatcher);
                }
            }, list);
            this.watchers.put(optionalFile, consumer);
        }
    }

    public VBox addTab(String string, String string2) {
        Tab tab = new Tab();
        tab.setText(string2);
        VBox vBox = new VBox();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)vBox);
        scrollPane.setFitToWidth(true);
        tab.setContent((Node)scrollPane);
        this.tabs.put(string, tab);
        this.tabPane.getTabs().add((Object)tab);
        return vBox;
    }

    public Consumer<Boolean> add(String string, String string2, String string3, boolean bl, int n, Consumer<Boolean> consumer, List<String> list) {
        HBox hBox;
        VBox vBox = new VBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        VBox.setMargin((Node)vBox, (Insets)new Insets(0.0, 0.0, 0.0, (double)(30 * --n)));
        vBox.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                checkBox.setSelected(!checkBox.isSelected());
                consumer.accept(checkBox.isSelected());
            }
        });
        vBox.setOnTouchPressed(touchEvent -> {
            checkBox.setSelected(!checkBox.isSelected());
            consumer.accept(checkBox.isSelected());
        });
        vBox.getStyleClass().add((Object)"optional-container");
        checkBox.setSelected(bl);
        checkBox.setText(string2);
        checkBox.setOnAction(actionEvent -> consumer.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"optional-checkbox");
        label.setText(string3);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"optional-label");
        if (!list.isEmpty()) {
            hBox = new HBox();
            hBox.getStyleClass().add((Object)"optional-library-container");
            for (String string4 : list) {
                Label label2 = new Label();
                label2.setText(string4);
                label2.getStyleClass().add((Object)"optional-library");
                hBox.getChildren().add((Object)label2);
            }
            vBox.getChildren().add((Object)hBox);
        }
        boolean bl2 = this.tabs.isEmpty();
        hBox = this.tabs.containsKey(string) ? (VBox)((ScrollPane)this.tabs.get(string).getContent()).getContent() : this.addTab(string, this.application.getTranslation(String.format("runtime.scenes.options.tabs.%s", string), string));
        hBox.getChildren().add((Object)vBox);
        if (bl2) {
            this.tabPane.getSelectionModel().select(0);
        }
        return arg_0 -> ((CheckBox)checkBox).setSelected(arg_0);
    }
}

