/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;
import pro.gravit.utils.helper.LogHelper;

public class LoginAndPasswordAuthMethod
extends AbstractAuthMethod<AuthPasswordDetails> {
    private final LoginAndPasswordOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public LoginAndPasswordAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.accessor = loginSceneAccessor;
        this.application = loginSceneAccessor.getApplication();
        this.overlay = new LoginAndPasswordOverlay(this.application);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthPasswordDetails authPasswordDetails) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            ContextHelper.runInFxThreadStatic(() -> {
                this.accessor.showContent(this.overlay);
                completableFuture.complete(null);
            }).exceptionally(throwable -> {
                LogHelper.error(throwable);
                return null;
            });
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthPasswordDetails authPasswordDetails) {
        this.overlay.future = new CompletableFuture();
        String string = this.overlay.login.getText();
        if (this.overlay.password.getText().isEmpty() && this.overlay.password.getPromptText().equals(this.application.getTranslation("runtime.scenes.login.password.saved"))) {
            AuthRequest.AuthPasswordInterface authPasswordInterface = this.application.runtimeSettings.password;
            return CompletableFuture.completedFuture(new LoginScene.LoginAndPasswordResult(string, authPasswordInterface));
        }
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
        this.overlay.future.complete(this.overlay.getResult());
    }

    @Override
    public void onUserCancel() {
        this.overlay.future.completeExceptionally(LoginAndPasswordOverlay.USER_AUTH_CANCELED_EXCEPTION);
    }

    @Override
    public CompletableFuture<Void> hide() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOverlay() {
        return false;
    }

    public class LoginAndPasswordOverlay
    extends AbstractVisualComponent {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField login;
        private TextField password;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;

        public LoginAndPasswordOverlay(JavaFXApplication javaFXApplication) {
            super("scenes/login/methods/loginpassword.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "loginandpassword";
        }

        public LoginScene.LoginAndPasswordResult getResult() {
            String string = this.login.getText();
            String string2 = this.password.getText();
            return new LoginScene.LoginAndPasswordResult(string, this.application.authService.makePassword(string2));
        }

        @Override
        protected void doInit() {
            this.login = (TextField)LookupHelper.lookup((Node)this.layout, "#login");
            this.password = (TextField)LookupHelper.lookup((Node)this.layout, "#password");
            this.login.textProperty().addListener(observable -> LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(this.login.getText().isEmpty() ? LoginAuthButtonComponent.AuthButtonState.UNACTIVE : LoginAuthButtonComponent.AuthButtonState.ACTIVE));
            if (this.application.runtimeSettings.login != null) {
                this.login.setText(this.application.runtimeSettings.login);
                LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(LoginAuthButtonComponent.AuthButtonState.ACTIVE);
            } else {
                LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(LoginAuthButtonComponent.AuthButtonState.UNACTIVE);
            }
            if (this.application.runtimeSettings.password != null) {
                this.password.getStyleClass().add((Object)"hasSaved");
                this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password.saved"));
            }
        }

        @Override
        protected void doPostInit() {
        }

        @Override
        public void reset() {
            if (this.password == null) {
                return;
            }
            this.password.getStyleClass().removeAll((Object[])new String[]{"hasSaved"});
            this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password"));
            this.password.setText("");
            this.login.setText("");
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }
    }
}

