/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.client.gui.scenes.login.methods.LoginAndPasswordAuthMethod;
import pro.gravit.launcher.client.gui.scenes.login.methods.LoginOnlyAuthMethod;
import pro.gravit.launcher.client.gui.scenes.login.methods.TotpAuthMethod;
import pro.gravit.launcher.client.gui.scenes.login.methods.WebAuthMethod;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.request.auth.details.AuthTotpDetails;
import pro.gravit.launcher.request.auth.details.AuthWebViewDetails;
import pro.gravit.launcher.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.launcher.utils.LauncherUpdater;
import pro.gravit.utils.helper.LogHelper;

public class LoginScene
extends AbstractScene {
    public Map<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>> authMethods = new HashMap<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>>(8);
    public boolean isLoginStarted;
    private List<GetAvailabilityAuthRequestEvent.AuthAvailability> auth;
    private CheckBox savePasswordCheckBox;
    private CheckBox autoenter;
    private Pane content;
    private AbstractVisualComponent contentComponent;
    private LoginAuthButtonComponent authButton;
    private ComboBox<GetAvailabilityAuthRequestEvent.AuthAvailability> authList;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
    private final AuthFlow authFlow = new AuthFlow();

    public LoginScene(JavaFXApplication javaFXApplication) {
        super("scenes/login/login.fxml", javaFXApplication);
        LoginSceneAccessor loginSceneAccessor = new LoginSceneAccessor();
        this.authMethods.put(AuthPasswordDetails.class, new LoginAndPasswordAuthMethod(loginSceneAccessor));
        this.authMethods.put(AuthWebViewDetails.class, new WebAuthMethod(loginSceneAccessor));
        this.authMethods.put(AuthTotpDetails.class, new TotpAuthMethod(loginSceneAccessor));
        this.authMethods.put(AuthLoginOnlyDetails.class, new LoginOnlyAuthMethod(loginSceneAccessor));
    }

    @Override
    public void doInit() {
        this.authButton = new LoginAuthButtonComponent((Button)LookupHelper.lookup((Node)this.layout, "#authButton"), this.application, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.contextHelper.runCallback(this::loginWithGui)));
        this.savePasswordCheckBox = (CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword");
        if (this.application.runtimeSettings.password != null || this.application.runtimeSettings.oauthAccessToken != null) {
            ((CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword")).setSelected(true);
        }
        this.autoenter = (CheckBox)LookupHelper.lookup((Node)this.layout, "#autoenter");
        this.autoenter.setSelected(this.application.runtimeSettings.autoAuth);
        this.autoenter.setOnAction(actionEvent -> {
            this.application.runtimeSettings.autoAuth = this.autoenter.isSelected();
        });
        this.content = (Pane)LookupHelper.lookup((Node)this.layout, "#content");
        if (this.application.guiModuleConfig.createAccountURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#createAccount")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
        }
        if (this.application.guiModuleConfig.forgotPassURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#forgotPass")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
        }
        this.authList = (ComboBox)LookupHelper.lookup((Node)this.layout, "#authList");
        this.authList.setConverter((StringConverter)new AuthAvailabilityStringConverter());
        this.authList.setOnAction(actionEvent -> this.changeAuthAvailability((GetAvailabilityAuthRequestEvent.AuthAvailability)this.authList.getSelectionModel().getSelectedItem()));
        this.authMethods.forEach((clazz, abstractAuthMethod) -> abstractAuthMethod.prepare());
    }

    @Override
    protected void doPostInit() {
        if (!this.application.isDebugMode()) {
            this.launcherRequest();
        } else {
            this.getAvailabilityAuth();
        }
    }

    private void launcherRequest() {
        LauncherRequest launcherRequest = new LauncherRequest();
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.launcher"), launcherRequest, launcherRequestEvent -> {
            if (launcherRequestEvent.needUpdate) {
                try {
                    LogHelper.debug("Start update processing");
                    this.disable();
                    StdJavaRuntimeProvider.updatePath = LauncherUpdater.prepareUpdate(new URL(launcherRequestEvent.url));
                    LogHelper.debug("Exit with Platform.exit");
                    Platform.exit();
                    return;
                }
                catch (Throwable throwable) {
                    this.contextHelper.runInFxThread(() -> this.errorHandle(throwable));
                    try {
                        Thread.sleep(1500L);
                        LauncherEngine.modulesManager.invokeEvent(new ClientExitPhase(0));
                        Platform.exit();
                    }
                    catch (Throwable throwable2) {
                        LauncherEngine.exitLauncher(0);
                    }
                }
            }
            LogHelper.dev("Launcher update processed");
            this.getAvailabilityAuth();
        }, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> LauncherEngine.exitLauncher(0)));
    }

    private void getAvailabilityAuth() {
        GetAvailabilityAuthRequest getAvailabilityAuthRequest = new GetAvailabilityAuthRequest();
        this.processing(getAvailabilityAuthRequest, this.application.getTranslation("runtime.overlay.processing.text.authAvailability"), getAvailabilityAuthRequestEvent -> this.contextHelper.runInFxThread(() -> {
            this.auth = getAvailabilityAuthRequestEvent.list;
            this.authList.setVisible(getAvailabilityAuthRequestEvent.list.size() != 1);
            for (GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability : getAvailabilityAuthRequestEvent.list) {
                if (!authAvailability.visible) continue;
                if (this.application.runtimeSettings.lastAuth == null) {
                    if (authAvailability.name.equals("std") || this.authAvailability == null) {
                        this.changeAuthAvailability(authAvailability);
                    }
                } else if (authAvailability.name.equals(this.application.runtimeSettings.lastAuth.name)) {
                    this.changeAuthAvailability(authAvailability);
                }
                this.addAuthAvailability(authAvailability);
            }
            if (this.authAvailability == null && getAvailabilityAuthRequestEvent.list.size() > 0) {
                this.changeAuthAvailability(getAvailabilityAuthRequestEvent.list.get(0));
            }
            this.runAutoAuth();
        }), null);
    }

    private void runAutoAuth() {
        if (this.application.guiModuleConfig.autoAuth || this.application.runtimeSettings.autoAuth) {
            this.contextHelper.runInFxThread(this::loginWithGui);
        }
    }

    public void changeAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        boolean bl = this.authAvailability != authAvailability;
        this.authAvailability = authAvailability;
        this.application.authService.setAuthAvailability(authAvailability);
        ((SingleSelectionModel)this.authList.selectionModelProperty().get()).select((Object)authAvailability);
        this.authFlow.init(authAvailability);
        LogHelper.info("Selected auth: %s", authAvailability.name);
    }

    public void addAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authList.getItems().add((Object)authAvailability);
        LogHelper.info("Added %s: %s", authAvailability.name, authAvailability.displayName);
    }

    public <T extends WebSocketEvent> void processing(Request<T> request, String string, Consumer<T> consumer, Consumer<String> consumer2) {
        this.processRequest(string, request, consumer, throwable -> consumer2.accept(throwable.getCause().getMessage()), null);
    }

    @Override
    public void errorHandle(Throwable throwable) {
        super.errorHandle(throwable);
        this.contextHelper.runInFxThread(() -> this.authButton.setState(LoginAuthButtonComponent.AuthButtonState.ERROR));
    }

    @Override
    public void reset() {
        this.authFlow.reset();
        for (AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> abstractAuthMethod : this.authMethods.values()) {
            abstractAuthMethod.reset();
        }
    }

    @Override
    public String getName() {
        return "login";
    }

    private boolean tryOAuthLogin() {
        if (this.application.runtimeSettings.lastAuth != null && this.authAvailability.name.equals(this.application.runtimeSettings.lastAuth.name) && this.application.runtimeSettings.oauthAccessToken != null) {
            if (this.application.runtimeSettings.oauthExpire != 0L && this.application.runtimeSettings.oauthExpire < System.currentTimeMillis()) {
                this.refreshToken();
                return true;
            }
            Request.setOAuth(this.authAvailability.name, new AuthRequestEvent.OAuthRequestEvent(this.application.runtimeSettings.oauthAccessToken, this.application.runtimeSettings.oauthRefreshToken, this.application.runtimeSettings.oauthExpire), this.application.runtimeSettings.oauthExpire);
            AuthOAuthPassword authOAuthPassword = new AuthOAuthPassword(this.application.runtimeSettings.oauthAccessToken);
            LogHelper.info("Login with OAuth AccessToken");
            this.loginWithOAuth(authOAuthPassword, this.authAvailability, true);
            return true;
        }
        return false;
    }

    private void refreshToken() {
        RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(this.authAvailability.name, this.application.runtimeSettings.oauthRefreshToken);
        this.processing(refreshTokenRequest, this.application.getTranslation("runtime.overlay.processing.text.auth"), refreshTokenRequestEvent -> {
            this.application.runtimeSettings.oauthAccessToken = refreshTokenRequestEvent.oauth.accessToken;
            this.application.runtimeSettings.oauthRefreshToken = refreshTokenRequestEvent.oauth.refreshToken;
            this.application.runtimeSettings.oauthExpire = refreshTokenRequestEvent.oauth.expire == 0L ? 0L : System.currentTimeMillis() + refreshTokenRequestEvent.oauth.expire;
            Request.setOAuth(this.authAvailability.name, refreshTokenRequestEvent.oauth);
            AuthOAuthPassword authOAuthPassword = new AuthOAuthPassword(this.application.runtimeSettings.oauthAccessToken);
            LogHelper.info("Login with OAuth AccessToken");
            this.loginWithOAuth(authOAuthPassword, this.authAvailability, false);
        }, string -> {
            this.application.runtimeSettings.oauthAccessToken = null;
            this.application.runtimeSettings.oauthRefreshToken = null;
            this.contextHelper.runInFxThread(this::loginWithGui);
        });
    }

    private void loginWithOAuth(AuthOAuthPassword authOAuthPassword, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability, boolean bl) {
        AuthRequest authRequest = this.application.authService.makeAuthRequest(null, authOAuthPassword, authAvailability.name);
        this.processing(authRequest, this.application.getTranslation("runtime.overlay.processing.text.auth"), authRequestEvent -> this.contextHelper.runInFxThread(() -> this.onSuccessLogin(new SuccessAuth((AuthRequestEvent)authRequestEvent, null, null))), string -> {
            if (bl && string.equals("auth.expiretoken")) {
                this.refreshToken();
                return;
            }
            if (string.equals("auth.invalidtoken")) {
                this.application.runtimeSettings.oauthAccessToken = null;
                this.application.runtimeSettings.oauthRefreshToken = null;
                this.contextHelper.runInFxThread(this::loginWithGui);
            } else {
                this.errorHandle(new RequestException((String)string));
            }
        });
    }

    private AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> detailsToMethod(GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails authAvailabilityDetails) {
        return this.authMethods.get(authAvailabilityDetails.getClass());
    }

    private void loginWithGui() {
        this.authButton.setState(LoginAuthButtonComponent.AuthButtonState.UNACTIVE);
        AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> abstractAuthMethod = this.authFlow.getAuthMethodOnShow();
        if (abstractAuthMethod != null) {
            abstractAuthMethod.onAuthClicked();
            return;
        }
        if (this.tryOAuthLogin()) {
            return;
        }
        this.authFlow.start().thenAccept(successAuth -> this.contextHelper.runInFxThread(() -> this.onSuccessLogin((SuccessAuth)successAuth)));
    }

    private boolean checkSavePasswordAvailable(AuthRequest.AuthPasswordInterface authPasswordInterface) {
        if (authPasswordInterface instanceof Auth2FAPassword) {
            return false;
        }
        if (authPasswordInterface instanceof AuthMultiPassword) {
            return false;
        }
        return this.authAvailability != null && this.authAvailability.details != null && this.authAvailability.details.size() != 0 && this.authAvailability.details.get(0) instanceof AuthPasswordDetails;
    }

    private void onSuccessLogin(SuccessAuth successAuth) {
        AuthRequestEvent authRequestEvent = successAuth.requestEvent;
        this.application.authService.setAuthResult(this.authAvailability.name, authRequestEvent);
        boolean bl = this.savePasswordCheckBox.isSelected();
        if (bl) {
            this.application.runtimeSettings.login = successAuth.recentLogin;
            if (authRequestEvent.oauth == null) {
                LogHelper.warning("Password not saved");
            } else {
                this.application.runtimeSettings.oauthAccessToken = authRequestEvent.oauth.accessToken;
                this.application.runtimeSettings.oauthRefreshToken = authRequestEvent.oauth.refreshToken;
                this.application.runtimeSettings.oauthExpire = Request.getTokenExpiredTime();
                this.application.runtimeSettings.password = null;
            }
            this.application.runtimeSettings.lastAuth = this.authAvailability;
        }
        if (authRequestEvent.playerProfile != null && authRequestEvent.playerProfile.assets != null) {
            try {
                Texture texture = authRequestEvent.playerProfile.assets.get("SKIN");
                Texture texture2 = authRequestEvent.playerProfile.assets.get("AVATAR");
                if (texture != null || texture2 != null) {
                    this.application.skinManager.addSkinWithAvatar(authRequestEvent.playerProfile.username, texture != null ? new URL(texture.url) : null, texture2 != null ? new URL(texture2.url) : null);
                    this.application.skinManager.getSkin(authRequestEvent.playerProfile.username);
                }
            }
            catch (Exception exception) {
                LogHelper.error(exception);
            }
        }
        this.contextHelper.runInFxThread(() -> {
            if (this.application.gui.welcomeOverlay.isInit()) {
                this.application.gui.welcomeOverlay.reset();
            }
            this.showOverlay(this.application.gui.welcomeOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent2 -> this.application.gui.welcomeOverlay.hide(2000.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.onGetProfiles()))));
        });
    }

    public void onGetProfiles() {
        this.processing(new ProfilesRequest(), this.application.getTranslation("runtime.overlay.processing.text.profiles"), profilesRequestEvent -> {
            this.application.profilesService.setProfilesResult((ProfilesRequestEvent)profilesRequestEvent);
            this.application.runtimeSettings.profiles = profilesRequestEvent.profiles;
            this.contextHelper.runInFxThread(() -> {
                AbstractScene abstractScene;
                this.application.securityService.startRequest();
                if (this.application.gui.optionsScene != null) {
                    try {
                        this.application.profilesService.loadAll();
                    }
                    catch (Throwable throwable) {
                        this.errorHandle(throwable);
                    }
                }
                if ((abstractScene = this.application.getCurrentScene()) instanceof LoginScene) {
                    LoginScene loginScene = (LoginScene)abstractScene;
                    loginScene.isLoginStarted = false;
                }
                this.application.setMainScene(this.application.gui.serverMenuScene);
            });
        }, null);
    }

    public void clearPassword() {
        this.application.runtimeSettings.encryptedPassword = null;
        this.application.runtimeSettings.password = null;
        this.application.runtimeSettings.login = null;
        this.application.runtimeSettings.oauthAccessToken = null;
        this.application.runtimeSettings.oauthRefreshToken = null;
    }

    public class AuthFlow {
        private final List<Integer> authFlow = new ArrayList<Integer>();
        private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
        private volatile AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> authMethodOnShow;

        public void init(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
            this.authAvailability = authAvailability;
            this.reset();
        }

        public void reset() {
            this.authFlow.clear();
            this.authFlow.add(0);
            if (this.authMethodOnShow != null) {
                this.authMethodOnShow.onUserCancel();
            }
            if (LoginScene.this.content.getChildren().size() != 0) {
                LoginScene.this.content.getChildren().clear();
                LoginScene.this.authButton.setState(LoginAuthButtonComponent.AuthButtonState.ACTIVE);
            }
            if (this.authMethodOnShow != null && !this.authMethodOnShow.isOverlay()) {
                LoginScene.this.loginWithGui();
            }
            this.authMethodOnShow = null;
        }

        private CompletableFuture<LoginAndPasswordResult> tryLogin(String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            CompletionStage<LoginAndPasswordResult> completionStage = null;
            if (authPasswordInterface != null) {
                completionStage = new CompletableFuture<LoginAndPasswordResult>();
                ((CompletableFuture)completionStage).complete(new LoginAndPasswordResult(string, authPasswordInterface));
            }
            for (int n : this.authFlow) {
                GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails authAvailabilityDetails = this.authAvailability.details.get(n);
                AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> abstractAuthMethod = LoginScene.this.detailsToMethod(authAvailabilityDetails);
                if (completionStage == null) {
                    completionStage = ((CompletableFuture)((CompletableFuture)abstractAuthMethod.show(authAvailabilityDetails).thenCompose(void_ -> {
                        this.authMethodOnShow = abstractAuthMethod;
                        return CompletableFuture.completedFuture(void_);
                    })).thenCompose(void_ -> abstractAuthMethod.auth(authAvailabilityDetails))).thenCompose(loginAndPasswordResult -> {
                        this.authMethodOnShow = null;
                        return CompletableFuture.completedFuture(loginAndPasswordResult);
                    });
                } else {
                    completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> abstractAuthMethod.show(authAvailabilityDetails).thenApply(void_ -> loginAndPasswordResult));
                    completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> {
                        this.authMethodOnShow = abstractAuthMethod;
                        return CompletableFuture.completedFuture(loginAndPasswordResult);
                    });
                    completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> abstractAuthMethod.auth(authAvailabilityDetails).thenApply(loginAndPasswordResult2 -> {
                        AuthRequest.AuthPasswordInterface authPasswordInterface;
                        AuthRequest.AuthPasswordInterface authPasswordInterface2;
                        String string = null;
                        if (loginAndPasswordResult.login != null) {
                            string = loginAndPasswordResult.login;
                        }
                        if (loginAndPasswordResult2.login != null) {
                            string = loginAndPasswordResult2.login;
                        }
                        if ((authPasswordInterface2 = loginAndPasswordResult.password) instanceof AuthMultiPassword) {
                            AuthMultiPassword authMultiPassword = (AuthMultiPassword)authPasswordInterface2;
                            authPasswordInterface = loginAndPasswordResult.password;
                            authMultiPassword.list.add(loginAndPasswordResult2.password);
                        } else {
                            authPasswordInterface2 = loginAndPasswordResult.password;
                            if (authPasswordInterface2 instanceof Auth2FAPassword) {
                                Auth2FAPassword auth2FAPassword = (Auth2FAPassword)authPasswordInterface2;
                                authPasswordInterface = new AuthMultiPassword();
                                ((AuthMultiPassword)authPasswordInterface).list = new ArrayList<AuthRequest.AuthPasswordInterface>();
                                ((AuthMultiPassword)authPasswordInterface).list.add(auth2FAPassword.firstPassword);
                                ((AuthMultiPassword)authPasswordInterface).list.add(auth2FAPassword.secondPassword);
                                ((AuthMultiPassword)authPasswordInterface).list.add(loginAndPasswordResult2.password);
                            } else {
                                authPasswordInterface = new Auth2FAPassword();
                                ((Auth2FAPassword)authPasswordInterface).firstPassword = loginAndPasswordResult.password;
                                ((Auth2FAPassword)authPasswordInterface).secondPassword = loginAndPasswordResult2.password;
                            }
                        }
                        return new LoginAndPasswordResult(string, authPasswordInterface);
                    }));
                    completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> {
                        this.authMethodOnShow = null;
                        return CompletableFuture.completedFuture(loginAndPasswordResult);
                    });
                }
                completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> abstractAuthMethod.hide().thenApply(void_ -> loginAndPasswordResult));
            }
            return completionStage;
        }

        public AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getAuthMethodOnShow() {
            return this.authMethodOnShow;
        }

        private void start(CompletableFuture<SuccessAuth> completableFuture, String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            CompletableFuture<LoginAndPasswordResult> completableFuture2 = this.tryLogin(string, authPasswordInterface);
            ((CompletableFuture)completableFuture2.thenAccept(loginAndPasswordResult -> this.login(loginAndPasswordResult.login, loginAndPasswordResult.password, this.authAvailability, completableFuture))).exceptionally(throwable -> {
                throwable = throwable.getCause();
                this.reset();
                LoginScene.this.isLoginStarted = false;
                if (throwable instanceof AbstractAuthMethod.UserAuthCanceledException) {
                    return null;
                }
                LoginScene.this.errorHandle((Throwable)throwable);
                return null;
            });
        }

        private CompletableFuture<SuccessAuth> start() {
            CompletableFuture<SuccessAuth> completableFuture = new CompletableFuture<SuccessAuth>();
            this.start(completableFuture, null, null);
            return completableFuture;
        }

        private void login(String string, AuthRequest.AuthPasswordInterface authPasswordInterface, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability, CompletableFuture<SuccessAuth> completableFuture) {
            LoginScene.this.isLoginStarted = true;
            LogHelper.dev("Auth with %s password ***** authId %s", string, authAvailability);
            AuthRequest authRequest = ((LoginScene)LoginScene.this).application.authService.makeAuthRequest(string, authPasswordInterface, authAvailability.name);
            LoginScene.this.processing(authRequest, LoginScene.this.application.getTranslation("runtime.overlay.processing.text.auth"), authRequestEvent -> completableFuture.complete(new SuccessAuth((AuthRequestEvent)authRequestEvent, string, authPasswordInterface)), string2 -> {
                if (string2.equals("auth.invalidtoken")) {
                    ((LoginScene)LoginScene.this).application.runtimeSettings.oauthAccessToken = null;
                    ((LoginScene)LoginScene.this).application.runtimeSettings.oauthRefreshToken = null;
                    completableFuture.completeExceptionally(new RequestException((String)string2));
                } else if (string2.equals("auth.require2fa")) {
                    this.authFlow.clear();
                    this.authFlow.add(1);
                    LoginScene.this.contextHelper.runInFxThread(() -> this.start(completableFuture, string, authPasswordInterface));
                } else if (string2.startsWith("auth.require.factor.")) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (String string3 : string2.substring("auth.require.factor.".length() + 1).split("\\.")) {
                        arrayList.add(Integer.parseInt(string3));
                    }
                    this.authFlow.clear();
                    this.authFlow.addAll(arrayList);
                    LoginScene.this.contextHelper.runInFxThread(() -> this.start(completableFuture, string, authPasswordInterface));
                } else {
                    this.authFlow.clear();
                    this.authFlow.add(0);
                    LoginScene.this.errorHandle(new RequestException((String)string2));
                }
            });
        }
    }

    public class LoginSceneAccessor {
        public void showOverlay(AbstractOverlay abstractOverlay, EventHandler<ActionEvent> eventHandler) throws Exception {
            LoginScene.this.showOverlay(abstractOverlay, eventHandler);
        }

        public void showContent(AbstractVisualComponent abstractVisualComponent) throws Exception {
            abstractVisualComponent.init();
            abstractVisualComponent.postInit();
            if (LoginScene.this.contentComponent != null) {
                LoginScene.this.content.getChildren().clear();
            }
            LoginScene.this.contentComponent = abstractVisualComponent;
            LoginScene.this.content.getChildren().add((Object)abstractVisualComponent.getLayout());
        }

        public JavaFXApplication getApplication() {
            return LoginScene.this.application;
        }

        public LoginAuthButtonComponent getAuthButton() {
            return LoginScene.this.authButton;
        }

        public void errorHandle(Throwable throwable) {
            LoginScene.this.errorHandle(throwable);
        }
    }

    private static class AuthAvailabilityStringConverter
    extends StringConverter<GetAvailabilityAuthRequestEvent.AuthAvailability> {
        private AuthAvailabilityStringConverter() {
        }

        public String toString(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
            return authAvailability == null ? "null" : authAvailability.displayName;
        }

        public GetAvailabilityAuthRequestEvent.AuthAvailability fromString(String string) {
            return null;
        }
    }

    public static class SuccessAuth {
        public AuthRequestEvent requestEvent;
        public String recentLogin;
        public AuthRequest.AuthPasswordInterface recentPassword;

        public SuccessAuth(AuthRequestEvent authRequestEvent, String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
            this.requestEvent = authRequestEvent;
            this.recentLogin = string;
            this.recentPassword = authPasswordInterface;
        }
    }

    public record LoginAndPasswordResult(String login, AuthRequest.AuthPasswordInterface password) {
    }
}

