/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes;

import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.ExitRequest;

public abstract class AbstractScene
extends AbstractVisualComponent {
    protected final LauncherConfig launcherConfig = Launcher.getConfig();
    protected Pane header;

    protected AbstractScene(String string, JavaFXApplication javaFXApplication) {
        super(string, javaFXApplication);
    }

    protected AbstractStage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void init() throws Exception {
        this.layout = (Pane)LookupHelper.lookupIfPossible((Node)this.getFxmlRoot(), "#layout").orElse(this.getFxmlRoot());
        this.header = LookupHelper.lookupIfPossible((Node)this.layout, "#header").orElse(null);
        this.sceneBaseInit();
        super.init();
    }

    @Override
    protected abstract void doInit();

    @Override
    protected void doPostInit() {
    }

    public void showOverlay(AbstractOverlay abstractOverlay, EventHandler<ActionEvent> eventHandler) throws Exception {
        abstractOverlay.show(this.currentStage, eventHandler);
    }

    protected final <T extends WebSocketEvent> void processRequest(String string, Request<T> request, Consumer<T> consumer, EventHandler<ActionEvent> eventHandler) {
        this.application.gui.processingOverlay.processRequest(this.currentStage, string, request, consumer, eventHandler);
    }

    protected final <T extends WebSocketEvent> void processRequest(String string, Request<T> request, Consumer<T> consumer, Consumer<Throwable> consumer2, EventHandler<ActionEvent> eventHandler) {
        this.application.gui.processingOverlay.processRequest(this.currentStage, string, request, consumer, consumer2, eventHandler);
    }

    protected void sceneBaseInit() {
        this.initBasicControls((Parent)this.header);
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#deauth").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.exitDialog.header"), this.application.getTranslation("runtime.scenes.settings.exitDialog.description"), this::userExit, () -> {}, true)));
    }

    protected void userExit() {
        this.processRequest(this.application.getTranslation("runtime.scenes.settings.exitDialog.processing"), new ExitRequest(), exitRequestEvent -> ContextHelper.runInFxThreadStatic(() -> {
            this.application.gui.loginScene.clearPassword();
            this.application.gui.loginScene.reset();
            try {
                this.application.saveSettings();
                this.application.authService.exit();
                this.switchScene(this.application.gui.loginScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {}));
    }

    @Override
    public void disable() {
        this.currentStage.disable();
    }

    @Override
    public void enable() {
        this.currentStage.enable();
    }

    @Override
    public abstract void reset();

    protected void switchScene(AbstractScene abstractScene) throws Exception {
        this.currentStage.setScene(abstractScene);
    }

    public Node getHeader() {
        return this.header;
    }

    public static void runLater(double d, EventHandler<ActionEvent> eventHandler) {
        AbstractScene.fade(null, d, 0.0, 1.0, eventHandler);
    }
}

