/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.UUID;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.client.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.SettingsScene;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.utils.helper.LogHelper;

public class GuiEventHandler
implements RequestService.EventHandler {
    private final JavaFXApplication application;

    public GuiEventHandler(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    @Override
    public <T extends WebSocketEvent> boolean eventHandle(T t) {
        block10: {
            RequestEvent requestEvent;
            LogHelper.dev("Processing event %s", t.getType());
            if (t instanceof RequestEvent) {
                requestEvent = (RequestEvent)t;
                if (!requestEvent.requestUUID.equals(RequestEvent.eventUUID)) {
                    return false;
                }
            }
            try {
                AbstractScene abstractScene;
                if (t instanceof AuthRequestEvent) {
                    requestEvent = (AuthRequestEvent)t;
                    boolean bl = this.application.getCurrentScene() instanceof LoginScene;
                    ((LoginScene)this.application.getCurrentScene()).isLoginStarted = true;
                    LogHelper.dev("Receive auth event. Send next scene %s", bl ? "true" : "false");
                    this.application.authService.setAuthResult(null, (AuthRequestEvent)requestEvent);
                    if (bl && ((LoginScene)this.application.getCurrentScene()).isLoginStarted) {
                        ((LoginScene)this.application.getCurrentScene()).onGetProfiles();
                    }
                }
                if (!(t instanceof ProfilesRequestEvent)) break block10;
                requestEvent = (ProfilesRequestEvent)t;
                this.application.profilesService.setProfilesResult((ProfilesRequestEvent)requestEvent);
                if (this.application.profilesService.getProfile() != null) {
                    UUID uUID = this.application.profilesService.getProfile().getUUID();
                    for (ClientProfile clientProfile : this.application.profilesService.getProfiles()) {
                        if (!clientProfile.getUUID().equals(uUID)) continue;
                        this.application.profilesService.setProfile(clientProfile);
                        break;
                    }
                }
                if (!((abstractScene = this.application.getCurrentScene()) instanceof ServerMenuScene) && !(abstractScene instanceof ServerInfoScene)) {
                    if (!(abstractScene instanceof SettingsScene | abstractScene instanceof OptionsScene)) break block10;
                }
                abstractScene.contextHelper.runInFxThread(abstractScene::reset);
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
        return false;
    }
}

