/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.dialogs;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.helper.PositionHelper;
import pro.gravit.utils.helper.LogHelper;

public class NotificationDialog
extends AbstractDialog {
    private static final Map<PositionHelper.PositionInfo, NotificationSlotsInfo> slots = new HashMap<PositionHelper.PositionInfo, NotificationSlotsInfo>();
    private String header;
    private String text;
    private Text textHeader;
    private Text textDescription;
    private PositionHelper.PositionInfo positionInfo;
    private NotificationSlot positionSlot;
    private double positionOffset;

    public NotificationDialog(JavaFXApplication javaFXApplication, String string, String string2) {
        super("components/notification.fxml", javaFXApplication);
        this.header = string;
        this.text = string2;
    }

    @Override
    public String getName() {
        return "notify";
    }

    @Override
    protected void doInit() {
        this.textHeader = (Text)LookupHelper.lookup((Node)this.layout, "#notificationHeading");
        this.textDescription = (Text)LookupHelper.lookup((Node)this.layout, "#notificationText");
        this.layout.setOnMouseClicked(mouseEvent -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
        });
        this.textHeader.setText(this.header);
        this.textDescription.setText(this.text);
        this.setOnClose(() -> {
            if (this.positionSlot != null) {
                NotificationSlotsInfo notificationSlotsInfo = slots.get((Object)this.positionInfo);
                notificationSlotsInfo.remove(this.positionSlot);
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void setPosition(PositionHelper.PositionInfo positionInfo, NotificationSlot notificationSlot) {
        NotificationSlotsInfo notificationSlotsInfo;
        if (this.positionInfo != null) {
            notificationSlotsInfo = slots.get((Object)this.positionInfo);
            notificationSlotsInfo.remove(notificationSlot);
        }
        this.positionInfo = positionInfo;
        LogHelper.info("Notification position: %s", new Object[]{positionInfo});
        if (positionInfo == null) {
            return;
        }
        notificationSlotsInfo = slots.get((Object)positionInfo);
        if (notificationSlotsInfo == null) {
            notificationSlotsInfo = new NotificationSlotsInfo();
            slots.put(positionInfo, notificationSlotsInfo);
        }
        this.positionSlot = notificationSlot;
        this.positionOffset = notificationSlotsInfo.add(notificationSlot);
    }

    public void setHeader(String string) {
        this.header = string;
        if (this.isInit()) {
            this.textHeader.setText(string);
        }
    }

    public void setText(String string) {
        this.text = string;
        if (this.isInit()) {
            this.textDescription.setText(string);
        }
    }

    @Override
    public LookupHelper.Point2D getOutSceneCoords(Rectangle2D rectangle2D) {
        if (this.positionInfo == null) {
            LogHelper.info("Notification position: using central");
            return super.getOutSceneCoords(rectangle2D);
        }
        return PositionHelper.calculate(this.positionInfo, this.layout.getPrefWidth(), this.layout.getPrefHeight(), 0.0, 30.0 + this.positionOffset, rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    @Override
    public LookupHelper.Point2D getSceneCoords(Pane pane) {
        if (this.positionInfo == null) {
            return super.getSceneCoords(pane);
        }
        return PositionHelper.calculate(this.positionInfo, this.layout.getPrefWidth(), this.layout.getPrefHeight(), 0.0, 30.0 + this.positionOffset, pane.getPrefWidth(), pane.getPrefHeight());
    }

    @Override
    public void errorHandle(Throwable throwable) {
        LogHelper.error(throwable);
    }

    private static class NotificationSlotsInfo {
        private final LinkedList<NotificationSlot> stack = new LinkedList();

        private NotificationSlotsInfo() {
        }

        double add(NotificationSlot notificationSlot) {
            double d = 0.0;
            for (NotificationSlot notificationSlot2 : this.stack) {
                d += notificationSlot2.size;
            }
            this.stack.add(notificationSlot);
            return d;
        }

        void remove(NotificationSlot notificationSlot) {
            boolean bl = false;
            for (NotificationSlot notificationSlot2 : this.stack) {
                if (bl) {
                    notificationSlot2.onScroll.accept(notificationSlot.size);
                    continue;
                }
                if (notificationSlot != notificationSlot2) continue;
                bl = true;
            }
            this.stack.remove(notificationSlot);
        }
    }

    public record NotificationSlot(Consumer<Double> onScroll, double size) {
    }
}

