/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.utils.helper.LogHelper;

public class SkinManager {
    private final JavaFXApplication application;
    private final Map<String, SkinEntry> map = new ConcurrentHashMap<String, SkinEntry>();

    public SkinManager(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public void addSkin(String string, URL uRL) {
        this.map.put(string, new SkinEntry(uRL));
    }

    public void addOrReplaceSkin(String string, URL uRL) {
        SkinEntry skinEntry = this.map.get(string);
        if (skinEntry == null) {
            this.map.put(string, new SkinEntry(uRL));
        } else {
            this.map.put(string, new SkinEntry(uRL, skinEntry.avatarUrl));
        }
    }

    public void addSkinWithAvatar(String string, URL uRL, URL uRL2) {
        this.map.put(string, new SkinEntry(uRL, uRL2));
    }

    public BufferedImage getSkin(String string) {
        SkinEntry skinEntry = this.map.get(string);
        if (skinEntry == null) {
            return null;
        }
        return skinEntry.getFullImage();
    }

    public BufferedImage getSkinHead(String string) {
        SkinEntry skinEntry = this.map.get(string);
        if (skinEntry == null) {
            return null;
        }
        return skinEntry.getHeadImage();
    }

    public javafx.scene.image.Image getFxSkin(String string) {
        SkinEntry skinEntry = this.map.get(string);
        if (skinEntry == null) {
            return null;
        }
        return skinEntry.getFullFxImage();
    }

    public javafx.scene.image.Image getFxSkinHead(String string) {
        SkinEntry skinEntry = this.map.get(string);
        if (skinEntry == null) {
            return null;
        }
        return skinEntry.getHeadFxImage();
    }

    public BufferedImage getScaledSkin(String string, int n, int n2) {
        BufferedImage bufferedImage = this.getSkin(string);
        return SkinManager.scaleImage(bufferedImage, n, n2);
    }

    public BufferedImage getScaledSkinHead(String string, int n, int n2) {
        BufferedImage bufferedImage = this.getSkinHead(string);
        return SkinManager.scaleImage(bufferedImage, n, n2);
    }

    public javafx.scene.image.Image getScaledFxSkin(String string, int n, int n2) {
        BufferedImage bufferedImage = this.getSkin(string);
        return SkinManager.convertToFxImage(SkinManager.scaleImage(bufferedImage, n, n2));
    }

    public static BufferedImage sumBufferedImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = Math.max(bufferedImage.getWidth(), bufferedImage2.getWidth());
        int n2 = Math.max(bufferedImage.getHeight(), bufferedImage2.getHeight());
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        Color color = graphics2D.getColor();
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(color);
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.drawImage(bufferedImage2, null, 0, 0);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public javafx.scene.image.Image getScaledFxSkinHead(String string, int n, int n2) {
        BufferedImage bufferedImage = this.getSkinHead(string);
        if (bufferedImage == null) {
            return null;
        }
        return SkinManager.convertToFxImage(SkinManager.scaleImage(bufferedImage, n, n2));
    }

    private static BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            return null;
        }
        Image image = bufferedImage.getScaledInstance(n, n2, 2);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static BufferedImage downloadSkin(URL uRL) {
        BufferedImage bufferedImage;
        block12: {
            if (uRL == null) {
                return null;
            }
            HttpURLConnection httpURLConnection = null;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.connect();
            InputStream inputStream = httpURLConnection.getInputStream();
            try {
                bufferedImage = ImageIO.read(inputStream);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        LogHelper.dev("User texture not found" + fileNotFoundException.getMessage());
                        return null;
                    }
                }
                catch (IOException iOException) {
                    LogHelper.error(iOException);
                    return null;
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    private static BufferedImage getHeadLayerFromSkinImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = n / 64;
        int n3 = 8 * n2;
        int n4 = 40 * n2;
        int n5 = 8 * n2;
        LogHelper.debug("ShinHead debug: W: %d Scale: %d Offset: %d", n, n2, n3);
        return bufferedImage.getSubimage(n4, n5, n3, n3);
    }

    private static BufferedImage getHeadFromSkinImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = n / 64;
        int n3 = 8 * n2;
        LogHelper.debug("ShinHead debug: W: %d Scale: %d Offset: %d", n, n2, n3);
        return bufferedImage.getSubimage(n3, n3, n3, n3);
    }

    private static javafx.scene.image.Image convertToFxImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        return SkinManager.convertToFxImageJava8(bufferedImage);
    }

    private static javafx.scene.image.Image convertToFxImageJava8(BufferedImage object) {
        int n;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel;
        Object object2;
        Object object3;
        int n2 = ((BufferedImage)object).getWidth();
        int n3 = ((BufferedImage)object).getHeight();
        switch (((BufferedImage)object).getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                object3 = new BufferedImage(n2, n3, 3);
                object2 = ((BufferedImage)object3).createGraphics();
                ((Graphics)object2).drawImage((Image)object, 0, 0, null);
                ((Graphics)object2).dispose();
                object = object3;
            }
        }
        object3 = new WritableImage(n2, n3);
        object2 = (DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer();
        SampleModel sampleModel = ((BufferedImage)object).getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            n = singlePixelPackedSampleModel.getScanlineStride();
        } else {
            n = 0;
        }
        int n4 = n;
        singlePixelPackedSampleModel = ((BufferedImage)object).isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        object3.getPixelWriter().setPixels(0, 0, n2, n3, (PixelFormat)singlePixelPackedSampleModel, ((DataBufferInt)object2).getData(), ((DataBuffer)object2).getOffset(), n4);
        return object3;
    }

    private static class SkinEntry {
        final URL url;
        final URL avatarUrl;
        SoftReference<Optional<BufferedImage>> imageRef = new SoftReference<Object>(null);
        SoftReference<Optional<BufferedImage>> avatarRef = new SoftReference<Object>(null);
        SoftReference<Optional<javafx.scene.image.Image>> fxImageRef = new SoftReference<Object>(null);
        SoftReference<Optional<javafx.scene.image.Image>> fxAvatarRef = new SoftReference<Object>(null);

        private SkinEntry(URL uRL) {
            this.url = uRL;
            this.avatarUrl = null;
        }

        public SkinEntry(URL uRL, URL uRL2) {
            this.url = uRL;
            this.avatarUrl = uRL2;
        }

        synchronized BufferedImage getFullImage() {
            Optional<BufferedImage> optional = this.imageRef.get();
            if (optional == null) {
                optional = Optional.ofNullable(SkinManager.downloadSkin(this.url));
                this.imageRef = new SoftReference<Optional<BufferedImage>>(optional);
            }
            return optional.orElse(null);
        }

        synchronized javafx.scene.image.Image getFullFxImage() {
            Optional<javafx.scene.image.Image> optional = this.fxImageRef.get();
            if (optional == null) {
                BufferedImage bufferedImage = this.getFullImage();
                if (bufferedImage == null) {
                    return null;
                }
                optional = Optional.ofNullable(SkinManager.convertToFxImage(bufferedImage));
                this.fxImageRef = new SoftReference<Optional<javafx.scene.image.Image>>(optional);
            }
            return optional.orElse(null);
        }

        synchronized BufferedImage getHeadImage() {
            Optional<BufferedImage> optional = this.avatarRef.get();
            if (optional == null) {
                if (this.avatarUrl != null) {
                    optional = Optional.ofNullable(SkinManager.downloadSkin(this.avatarUrl));
                } else {
                    BufferedImage bufferedImage = this.getFullImage();
                    if (bufferedImage == null) {
                        return null;
                    }
                    optional = Optional.of(SkinManager.sumBufferedImage(SkinManager.getHeadFromSkinImage(bufferedImage), SkinManager.getHeadLayerFromSkinImage(bufferedImage)));
                }
                this.avatarRef = new SoftReference<Optional<BufferedImage>>(optional);
            }
            return optional.orElse(null);
        }

        synchronized javafx.scene.image.Image getHeadFxImage() {
            Optional<javafx.scene.image.Image> optional = this.fxAvatarRef.get();
            if (optional == null) {
                BufferedImage bufferedImage = this.getHeadImage();
                if (bufferedImage == null) {
                    return null;
                }
                optional = Optional.ofNullable(SkinManager.convertToFxImage(bufferedImage));
                this.fxAvatarRef = new SoftReference<Optional<javafx.scene.image.Image>>(optional);
            }
            return optional.orElse(null);
        }
    }
}

