/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworkIF;
import oshi.jna.Struct;
import oshi.util.ParseUtil;

@ThreadSafe
public final class WindowsNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworkIF.class);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final byte CONNECTOR_PRESENT_BIT = 4;
    private int ifType;
    private int ndisPhysicalMediumType;
    private boolean connectorPresent;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;
    private String ifAlias;
    private NetworkIF.IfOperStatus ifOperStatus;

    public WindowsNetworkIF(NetworkInterface networkInterface) throws InstantiationException {
        super(networkInterface);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean bl) {
        ArrayList<NetworkIF> arrayList = new ArrayList<NetworkIF>();
        for (NetworkInterface networkInterface : WindowsNetworkIF.getNetworkInterfaces(bl)) {
            try {
                arrayList.add(new WindowsNetworkIF(networkInterface));
            }
            catch (InstantiationException instantiationException) {
                LOG.debug("Network Interface Instantiation failed: {}", (Object)instantiationException.getMessage());
            }
        }
        return arrayList;
    }

    @Override
    public int getIfType() {
        return this.ifType;
    }

    @Override
    public int getNdisPhysicalMediumType() {
        return this.ndisPhysicalMediumType;
    }

    @Override
    public boolean isConnectorPresent() {
        return this.connectorPresent;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public String getIfAlias() {
        return this.ifAlias;
    }

    @Override
    public NetworkIF.IfOperStatus getIfOperStatus() {
        return this.ifOperStatus;
    }

    @Override
    public boolean updateAttributes() {
        if (IS_VISTA_OR_GREATER) {
            try (Struct.CloseableMibIfRow2 closeableMibIfRow2 = new Struct.CloseableMibIfRow2();){
                closeableMibIfRow2.InterfaceIndex = this.queryNetworkInterface().getIndex();
                if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(closeableMibIfRow2)) {
                    LOG.error("Failed to retrieve data for interface {}, {}", (Object)this.queryNetworkInterface().getIndex(), (Object)this.getName());
                    boolean bl = false;
                    return bl;
                }
                this.ifType = closeableMibIfRow2.Type;
                this.ndisPhysicalMediumType = closeableMibIfRow2.PhysicalMediumType;
                this.connectorPresent = (closeableMibIfRow2.InterfaceAndOperStatusFlags & 4) > 0;
                this.bytesSent = closeableMibIfRow2.OutOctets;
                this.bytesRecv = closeableMibIfRow2.InOctets;
                this.packetsSent = closeableMibIfRow2.OutUcastPkts;
                this.packetsRecv = closeableMibIfRow2.InUcastPkts;
                this.outErrors = closeableMibIfRow2.OutErrors;
                this.inErrors = closeableMibIfRow2.InErrors;
                this.collisions = closeableMibIfRow2.OutDiscards;
                this.inDrops = closeableMibIfRow2.InDiscards;
                this.speed = closeableMibIfRow2.ReceiveLinkSpeed;
                this.ifAlias = Native.toString(closeableMibIfRow2.Alias);
                this.ifOperStatus = NetworkIF.IfOperStatus.byValue(closeableMibIfRow2.OperStatus);
            }
        }
        try (Struct.CloseableMibIfRow closeableMibIfRow = new Struct.CloseableMibIfRow();){
            closeableMibIfRow.dwIndex = this.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(closeableMibIfRow)) {
                LOG.error("Failed to retrieve data for interface {}, {}", (Object)this.queryNetworkInterface().getIndex(), (Object)this.getName());
                boolean bl = false;
                return bl;
            }
            this.ifType = closeableMibIfRow.dwType;
            this.bytesSent = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwOutOctets);
            this.bytesRecv = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwInOctets);
            this.packetsSent = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwOutUcastPkts);
            this.packetsRecv = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwInUcastPkts);
            this.outErrors = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwOutErrors);
            this.inErrors = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwInErrors);
            this.collisions = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwOutDiscards);
            this.inDrops = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwInDiscards);
            this.speed = ParseUtil.unsignedIntToLong(closeableMibIfRow.dwSpeed);
            this.ifAlias = "";
            this.ifOperStatus = NetworkIF.IfOperStatus.UNKNOWN;
        }
        this.timeStamp = System.currentTimeMillis();
        return true;
    }
}

