/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.OpenBsdLibc;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.openbsd.OpenBsdSysctlUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public class OpenBsdCentralProcessor
extends AbstractCentralProcessor {
    private final Supplier<Pair<Long, Long>> vmStats = Memoizer.memoize(OpenBsdCentralProcessor::queryVmStats, Memoizer.defaultExpiration());
    private static final Pattern DMESG_CPU = Pattern.compile("cpu(\\d+): smt (\\d+), core (\\d+), package (\\d+)");

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String string = OpenBsdSysctlUtil.sysctl("machdep.cpuvendor", "");
        int[] nArray = new int[]{6, 2};
        String string2 = OpenBsdSysctlUtil.sysctl(nArray, "");
        int n = ParseUtil.hexStringToInt(OpenBsdSysctlUtil.sysctl("machdep.cpuid", ""), 0);
        int n2 = ParseUtil.hexStringToInt(OpenBsdSysctlUtil.sysctl("machdep.cpufeature", ""), 0);
        Triplet<Integer, Integer, Integer> triplet = OpenBsdCentralProcessor.cpuidToFamilyModelStepping(n);
        String string3 = triplet.getA().toString();
        String string4 = triplet.getB().toString();
        String string5 = triplet.getC().toString();
        long l = ParseUtil.parseHertz(string2);
        if (l < 0L) {
            l = this.queryMaxFreq();
        }
        nArray[1] = 1;
        String string6 = OpenBsdSysctlUtil.sysctl(nArray, "");
        boolean bl = string6 != null && string6.contains("64") || ExecutingCommand.getFirstAnswer("uname -m").trim().contains("64");
        String string7 = String.format("%08x%08x", n2, n);
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string7, bl, l);
    }

    private static Triplet<Integer, Integer, Integer> cpuidToFamilyModelStepping(int n) {
        int n2 = n >> 16 & 0xFF0 | n >> 8 & 0xF;
        int n3 = n >> 12 & 0xF0 | n >> 4 & 0xF;
        int n4 = n & 0xF;
        return new Triplet<Integer, Integer, Integer>(n2, n3, n4);
    }

    @Override
    protected long[] queryCurrentFreq() {
        long[] lArray = new long[1];
        int[] nArray = new int[]{6, 12};
        lArray[0] = OpenBsdSysctlUtil.sysctl(nArray, 0L) * 1000000L;
        return lArray;
    }

    @Override
    protected Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        for (String object2 : ExecutingCommand.runNative("dmesg")) {
            Matcher i = DMESG_CPU.matcher(object2);
            if (!i.matches()) continue;
            int pattern = ParseUtil.parseIntOrDefault(i.group(1), 0);
            hashMap.put(pattern, ParseUtil.parseIntOrDefault(i.group(3), 0));
            hashMap2.put(pattern, ParseUtil.parseIntOrDefault(i.group(4), 0));
        }
        int n = OpenBsdSysctlUtil.sysctl("hw.ncpuonline", 1);
        if (n < hashMap.keySet().size()) {
            n = hashMap.keySet().size();
        }
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>(n);
        for (int hashMap3 = 0; hashMap3 < n; ++hashMap3) {
            arrayList.add(new CentralProcessor.LogicalProcessor(hashMap3, hashMap.getOrDefault(hashMap3, 0), hashMap2.getOrDefault(hashMap3, 0)));
        }
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        Pattern pattern = Pattern.compile("cpu(\\\\d+).*: ((ARM|AMD|Intel|Apple).+)");
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        Pattern pattern2 = Pattern.compile("cpu(\\\\d+).*: (.+(I-|D-|L\\d+\\s)cache)");
        for (String string : ExecutingCommand.runNative("dmesg")) {
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                int matcher2 = ParseUtil.parseIntOrDefault(matcher.group(1), 0);
                hashMap3.put(matcher2, matcher.group(2).trim());
                continue;
            }
            Matcher matcher2 = pattern2.matcher(string);
            if (!matcher2.matches()) continue;
            for (String string2 : matcher2.group(1).split(",")) {
                CentralProcessor.ProcessorCache processorCache = this.parseCacheStr(string2);
                if (processorCache == null) continue;
                hashSet.add(processorCache);
            }
        }
        Iterator<String> iterator = hashMap3.isEmpty() ? null : this.createProcListFromDmesg(arrayList, hashMap3);
        return new Triplet<ArrayList<CentralProcessor.LogicalProcessor>, Iterator<String>, List<CentralProcessor.ProcessorCache>>(arrayList, iterator, OpenBsdCentralProcessor.orderedProcCaches(hashSet));
    }

    private CentralProcessor.ProcessorCache parseCacheStr(String string) {
        String[] stringArray = ParseUtil.whitespaces.split(string);
        if (stringArray.length > 3) {
            switch (stringArray[stringArray.length - 1]) {
                case "I-cache": {
                    return new CentralProcessor.ProcessorCache(1, ParseUtil.getFirstIntValue(stringArray[2]), ParseUtil.getFirstIntValue(stringArray[1]), ParseUtil.parseDecimalMemorySizeToBinary(stringArray[0]), CentralProcessor.ProcessorCache.Type.INSTRUCTION);
                }
                case "D-cache": {
                    return new CentralProcessor.ProcessorCache(1, ParseUtil.getFirstIntValue(stringArray[2]), ParseUtil.getFirstIntValue(stringArray[1]), ParseUtil.parseDecimalMemorySizeToBinary(stringArray[0]), CentralProcessor.ProcessorCache.Type.DATA);
                }
            }
            return new CentralProcessor.ProcessorCache(ParseUtil.getFirstIntValue(stringArray[3]), ParseUtil.getFirstIntValue(stringArray[2]), ParseUtil.getFirstIntValue(stringArray[1]), ParseUtil.parseDecimalMemorySizeToBinary(stringArray[0]), CentralProcessor.ProcessorCache.Type.UNIFIED);
        }
        return null;
    }

    @Override
    protected long queryContextSwitches() {
        return this.vmStats.get().getA();
    }

    @Override
    protected long queryInterrupts() {
        return this.vmStats.get().getB();
    }

    private static Pair<Long, Long> queryVmStats() {
        long l = 0L;
        long l2 = 0L;
        List<String> list = ExecutingCommand.runNative("vmstat -s");
        for (String string : list) {
            if (string.endsWith("cpu context switches")) {
                l = ParseUtil.getFirstIntValue(string);
                continue;
            }
            if (!string.endsWith("interrupts")) continue;
            l2 = ParseUtil.getFirstIntValue(string);
        }
        return new Pair<Long, Long>(l, l2);
    }

    @Override
    protected long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        int[] nArray = new int[]{1, 40};
        try (Memory memory = OpenBsdSysctlUtil.sysctl(nArray);){
            long[] lArray2 = OpenBsdCentralProcessor.cpTimeToTicks(memory, false);
            if (lArray2.length >= 5) {
                lArray[CentralProcessor.TickType.USER.getIndex()] = lArray2[0];
                lArray[CentralProcessor.TickType.NICE.getIndex()] = lArray2[1];
                lArray[CentralProcessor.TickType.SYSTEM.getIndex()] = lArray2[2];
                int n = lArray2.length > 5 ? 1 : 0;
                lArray[CentralProcessor.TickType.IRQ.getIndex()] = lArray2[3 + n];
                lArray[CentralProcessor.TickType.IDLE.getIndex()] = lArray2[4 + n];
            }
        }
        return lArray;
    }

    @Override
    protected long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 71;
        for (int i = 0; i < this.getLogicalProcessorCount(); ++i) {
            nArray[2] = i;
            try (Memory memory = OpenBsdSysctlUtil.sysctl(nArray);){
                long[] lArray2 = OpenBsdCentralProcessor.cpTimeToTicks(memory, true);
                if (lArray2.length < 5) continue;
                lArray[i][CentralProcessor.TickType.USER.getIndex()] = lArray2[0];
                lArray[i][CentralProcessor.TickType.NICE.getIndex()] = lArray2[1];
                lArray[i][CentralProcessor.TickType.SYSTEM.getIndex()] = lArray2[2];
                int n = lArray2.length > 5 ? 1 : 0;
                lArray[i][CentralProcessor.TickType.IRQ.getIndex()] = lArray2[3 + n];
                lArray[i][CentralProcessor.TickType.IDLE.getIndex()] = lArray2[4 + n];
                continue;
            }
        }
        return lArray;
    }

    private static long[] cpTimeToTicks(Memory memory, boolean bl) {
        int n;
        long l = bl ? 8L : (long)Native.LONG_SIZE;
        int n2 = n = memory == null ? 0 : (int)(memory.size() / l);
        if (bl && memory != null) {
            return memory.getLongArray(0L, n);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = memory.getNativeLong((long)i * l).longValue();
        }
        return lArray;
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] dArray = new double[n];
        int n2 = OpenBsdLibc.INSTANCE.getloadavg(dArray, n);
        if (n2 < n) {
            Arrays.fill(dArray, -1.0);
        }
        return dArray;
    }
}

