/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.ByRef;
import oshi.jna.Struct;
import oshi.util.FormatUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class MacCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MacCentralProcessor.class);
    private static final int ARM_CPUTYPE = 0x100000C;
    private static final int M1_CPUFAMILY = 458787763;
    private static final int M2_CPUFAMILY = -634136515;
    private static final long DEFAULT_FREQUENCY = 2400000000L;
    private static final Pattern CPU_N = Pattern.compile("^cpu(\\d+)");
    private final Supplier<String> vendor = Memoizer.memoize(MacCentralProcessor::platformExpert);
    private final boolean isArmCpu = this.isArmCpu();
    private long performanceCoreFrequency = 2400000000L;
    private long efficiencyCoreFrequency = 2400000000L;

    MacCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String string;
        String string2;
        int n;
        String string3;
        String string4;
        String string5;
        String string6 = SysctlUtil.sysctl("machdep.cpu.brand_string", "");
        if (string6.startsWith("Apple")) {
            int n2;
            string5 = this.vendor.get();
            string4 = "0";
            string3 = "0";
            if (this.isArmCpu) {
                n = 0x100000C;
                n2 = string6.contains("M2") ? -634136515 : 458787763;
            } else {
                n = SysctlUtil.sysctl("hw.cputype", 0);
                n2 = SysctlUtil.sysctl("hw.cpufamily", 0);
            }
            string2 = String.format("0x%08x", n2);
            string = String.format("%08x%08x", n, n2);
        } else {
            string5 = SysctlUtil.sysctl("machdep.cpu.vendor", "");
            n = SysctlUtil.sysctl("machdep.cpu.stepping", -1);
            string4 = n < 0 ? "" : Integer.toString(n);
            n = SysctlUtil.sysctl("machdep.cpu.model", -1);
            string3 = n < 0 ? "" : Integer.toString(n);
            n = SysctlUtil.sysctl("machdep.cpu.family", -1);
            string2 = n < 0 ? "" : Integer.toString(n);
            long l = 0L;
            l |= (long)SysctlUtil.sysctl("machdep.cpu.signature", 0);
            string = String.format("%016x", l |= (SysctlUtil.sysctl("machdep.cpu.feature_bits", 0L) & 0xFFFFFFFFFFFFFFFFL) << 32);
        }
        if (this.isArmCpu) {
            this.calculateNominalFrequencies();
        }
        long l = this.isArmCpu ? this.performanceCoreFrequency : SysctlUtil.sysctl("hw.cpufrequency", 0L);
        boolean bl = SysctlUtil.sysctl("hw.cpu64bit_capable", 0) != 0;
        return new CentralProcessor.ProcessorIdentifier(string5, string6, string2, string3, string4, string, bl, l);
    }

    @Override
    protected Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        int n2;
        int n3 = SysctlUtil.sysctl("hw.logicalcpu", 1);
        int n4 = SysctlUtil.sysctl("hw.physicalcpu", 1);
        int n5 = SysctlUtil.sysctl("hw.packages", 1);
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>(n3);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < n3; ++i) {
            n2 = i * n4 / n3;
            int n6 = i * n5 / n3;
            arrayList.add(new CentralProcessor.LogicalProcessor(i, n2, n6));
            hashSet.add((n6 << 16) + n2);
        }
        Map<Integer, String> map = MacCentralProcessor.queryCompatibleStrings();
        n2 = SysctlUtil.sysctl("hw.nperflevels", 1);
        List list = hashSet.stream().sorted().map(n -> {
            String string = map.getOrDefault(n, "").toLowerCase();
            int n2 = 0;
            if (string.contains("firestorm") || string.contains("avalanche")) {
                n2 = 1;
            }
            return new CentralProcessor.PhysicalProcessor(n >> 16, (int)(n & 0xFFFF), n2, string);
        }).collect(Collectors.toList());
        List<CentralProcessor.ProcessorCache> list2 = MacCentralProcessor.orderedProcCaches(this.getCacheValues(n2));
        return new Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>>(arrayList, list, list2);
    }

    private Set<CentralProcessor.ProcessorCache> getCacheValues(int n) {
        int n2 = (int)SysctlUtil.sysctl("hw.cachelinesize", 0L);
        int n3 = SysctlUtil.sysctl("machdep.cpu.cache.L1_associativity", 0, false);
        int n4 = SysctlUtil.sysctl("machdep.cpu.cache.L2_associativity", 0, false);
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        for (int i = 0; i < n; ++i) {
            int n5 = SysctlUtil.sysctl("hw.perflevel" + i + ".l1icachesize", 0, false);
            if (n5 > 0) {
                hashSet.add(new CentralProcessor.ProcessorCache(1, n3, n2, (long)n5, CentralProcessor.ProcessorCache.Type.INSTRUCTION));
            }
            if ((n5 = SysctlUtil.sysctl("hw.perflevel" + i + ".l1dcachesize", 0, false)) > 0) {
                hashSet.add(new CentralProcessor.ProcessorCache(1, n3, n2, (long)n5, CentralProcessor.ProcessorCache.Type.DATA));
            }
            if ((n5 = SysctlUtil.sysctl("hw.perflevel" + i + ".l2cachesize", 0, false)) > 0) {
                hashSet.add(new CentralProcessor.ProcessorCache(2, n4, n2, (long)n5, CentralProcessor.ProcessorCache.Type.UNIFIED));
            }
            if ((n5 = SysctlUtil.sysctl("hw.perflevel" + i + ".l3cachesize", 0, false)) <= 0) continue;
            hashSet.add(new CentralProcessor.ProcessorCache(3, 0, n2, (long)n5, CentralProcessor.ProcessorCache.Type.UNIFIED));
        }
        return hashSet;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        int n = SystemB.INSTANCE.mach_host_self();
        try (Struct.CloseableHostCpuLoadInfo closeableHostCpuLoadInfo = new Struct.CloseableHostCpuLoadInfo();
             ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(closeableHostCpuLoadInfo.size());){
            if (0 != SystemB.INSTANCE.host_statistics(n, 3, closeableHostCpuLoadInfo, closeableIntByReference)) {
                LOG.error("Failed to get System CPU ticks. Error code: {} ", (Object)Native.getLastError());
                long[] lArray2 = lArray;
                return lArray2;
            }
            lArray[CentralProcessor.TickType.USER.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[0];
            lArray[CentralProcessor.TickType.NICE.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[3];
            lArray[CentralProcessor.TickType.SYSTEM.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[1];
            lArray[CentralProcessor.TickType.IDLE.getIndex()] = closeableHostCpuLoadInfo.cpu_ticks[2];
        }
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (this.isArmCpu) {
            HashMap hashMap = new HashMap();
            this.getPhysicalProcessors().stream().forEach(physicalProcessor -> hashMap.put(physicalProcessor.getPhysicalProcessorNumber(), physicalProcessor.getEfficiency() > 0 ? this.performanceCoreFrequency : this.efficiencyCoreFrequency));
            return this.getLogicalProcessors().stream().map(CentralProcessor.LogicalProcessor::getPhysicalProcessorNumber).map(n -> hashMap.getOrDefault(n, this.performanceCoreFrequency)).mapToLong(l -> l).toArray();
        }
        return new long[]{this.getProcessorIdentifier().getVendorFreq()};
    }

    @Override
    public long queryMaxFreq() {
        if (this.isArmCpu) {
            return this.performanceCoreFrequency;
        }
        return SysctlUtil.sysctl("hw.cpufrequency_max", this.getProcessorIdentifier().getVendorFreq());
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] dArray = new double[n];
        int n2 = SystemB.INSTANCE.getloadavg(dArray, n);
        if (n2 < n) {
            Arrays.fill(dArray, -1.0);
        }
        return dArray;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int n = SystemB.INSTANCE.mach_host_self();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference();
             ByRef.CloseablePointerByReference closeablePointerByReference = new ByRef.CloseablePointerByReference();
             ByRef.CloseableIntByReference closeableIntByReference2 = new ByRef.CloseableIntByReference();){
            if (0 != SystemB.INSTANCE.host_processor_info(n, 2, closeableIntByReference, closeablePointerByReference, closeableIntByReference2)) {
                LOG.error("Failed to update CPU Load. Error code: {}", (Object)Native.getLastError());
                long[][] lArray2 = lArray;
                return lArray2;
            }
            int[] nArray = closeablePointerByReference.getValue().getIntArray(0L, closeableIntByReference2.getValue());
            for (int i = 0; i < closeableIntByReference.getValue(); ++i) {
                int n2 = i * 4;
                lArray[i][CentralProcessor.TickType.USER.getIndex()] = FormatUtil.getUnsignedInt(nArray[n2 + 0]);
                lArray[i][CentralProcessor.TickType.NICE.getIndex()] = FormatUtil.getUnsignedInt(nArray[n2 + 3]);
                lArray[i][CentralProcessor.TickType.SYSTEM.getIndex()] = FormatUtil.getUnsignedInt(nArray[n2 + 1]);
                lArray[i][CentralProcessor.TickType.IDLE.getIndex()] = FormatUtil.getUnsignedInt(nArray[n2 + 2]);
            }
        }
        return lArray;
    }

    @Override
    public long queryContextSwitches() {
        return 0L;
    }

    @Override
    public long queryInterrupts() {
        return 0L;
    }

    private static String platformExpert() {
        String string = null;
        IOKit.IOService iOService = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (iOService != null) {
            byte[] byArray = iOService.getByteArrayProperty("manufacturer");
            if (byArray != null) {
                string = Native.toString(byArray, StandardCharsets.UTF_8);
            }
            iOService.release();
        }
        return Util.isBlank(string) ? "Apple Inc." : string;
    }

    private static Map<Integer, String> queryCompatibleStrings() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        IOKit.IOIterator iOIterator = IOKitUtil.getMatchingServices("IOPlatformDevice");
        if (iOIterator != null) {
            IOKit.IORegistryEntry iORegistryEntry = iOIterator.next();
            while (iORegistryEntry != null) {
                Matcher matcher = CPU_N.matcher(iORegistryEntry.getName().toLowerCase());
                if (matcher.matches()) {
                    int n = ParseUtil.parseIntOrDefault(matcher.group(1), 0);
                    byte[] byArray = iORegistryEntry.getByteArrayProperty("compatible");
                    if (byArray != null) {
                        hashMap.put(n, new String(byArray, StandardCharsets.UTF_8).replace('\u0000', ' '));
                    }
                }
                iORegistryEntry.release();
                iORegistryEntry = iOIterator.next();
            }
            iOIterator.release();
        }
        return hashMap;
    }

    private boolean isArmCpu() {
        return this.getPhysicalProcessors().stream().map(CentralProcessor.PhysicalProcessor::getEfficiency).anyMatch(n -> n > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateNominalFrequencies() {
        IOKit.IOIterator iOIterator = IOKitUtil.getMatchingServices("AppleARMIODevice");
        if (iOIterator != null) {
            try {
                IOKit.IORegistryEntry iORegistryEntry = iOIterator.next();
                try {
                    while (true) {
                        if (iORegistryEntry != null) {
                            if (iORegistryEntry.getName().toLowerCase().equals("pmgr")) {
                                this.performanceCoreFrequency = this.getMaxFreqFromByteArray(iORegistryEntry.getByteArrayProperty("voltage-states5-sram"));
                                this.efficiencyCoreFrequency = this.getMaxFreqFromByteArray(iORegistryEntry.getByteArrayProperty("voltage-states1-sram"));
                                return;
                            }
                            iORegistryEntry.release();
                            iORegistryEntry = iOIterator.next();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (iORegistryEntry != null) {
                        iORegistryEntry.release();
                    }
                }
            }
            finally {
                iOIterator.release();
            }
        }
    }

    private long getMaxFreqFromByteArray(byte[] byArray) {
        if (byArray != null && byArray.length >= 8) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, byArray.length - 8, byArray.length - 4);
            return ParseUtil.byteArrayToLong(byArray2, 4, false);
        }
        return 2400000000L;
    }
}

