/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.DiscordEventAdapter;
import de.jcm.discordgamesdk.user.DiscordUser;
import de.jcm.discordgamesdk.user.Relationship;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DiscordEventHandler
extends DiscordEventAdapter {
    private final List<DiscordEventAdapter> listeners = new CopyOnWriteArrayList<DiscordEventAdapter>();

    public void addListener(DiscordEventAdapter discordEventAdapter) {
        this.listeners.add(discordEventAdapter);
    }

    public boolean removeListener(DiscordEventAdapter discordEventAdapter) {
        return this.listeners.remove(discordEventAdapter);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public void onActivityJoin(String string) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onActivityJoin(string));
    }

    @Override
    public void onActivitySpectate(String string) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onActivitySpectate(string));
    }

    @Override
    public void onActivityJoinRequest(DiscordUser discordUser) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onActivityJoinRequest(discordUser));
    }

    @Override
    public void onCurrentUserUpdate() {
        this.listeners.forEach(DiscordEventAdapter::onCurrentUserUpdate);
    }

    @Override
    public void onOverlayToggle(boolean bl) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onOverlayToggle(bl));
    }

    @Override
    public void onRelationshipRefresh() {
        this.listeners.forEach(DiscordEventAdapter::onRelationshipRefresh);
    }

    @Override
    public void onRelationshipUpdate(Relationship relationship) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onRelationshipUpdate(relationship));
    }
}

