/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import com.google.gson.Gson;
import de.jcm.discordgamesdk.ActivityManager;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.DiscordEventAdapter;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.ImageManager;
import de.jcm.discordgamesdk.LogLevel;
import de.jcm.discordgamesdk.OverlayManager;
import de.jcm.discordgamesdk.RelationshipManager;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.UserManager;
import de.jcm.discordgamesdk.VoiceManager;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.impl.ConnectionState;
import de.jcm.discordgamesdk.impl.Error;
import de.jcm.discordgamesdk.impl.EventHandler;
import de.jcm.discordgamesdk.impl.Events;
import de.jcm.discordgamesdk.impl.HandshakeMessage;
import de.jcm.discordgamesdk.impl.channel.DiscordChannel;
import de.jcm.discordgamesdk.impl.channel.UnixDiscordChannel;
import de.jcm.discordgamesdk.impl.channel.WindowsDiscordChannel;
import de.jcm.discordgamesdk.impl.commands.Subscribe;
import de.jcm.discordgamesdk.impl.events.OverlayUpdateEvent;
import de.jcm.discordgamesdk.impl.events.VoiceSettingsUpdate2Event;
import de.jcm.discordgamesdk.user.DiscordUser;
import de.jcm.discordgamesdk.user.Relationship;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Core
implements AutoCloseable {
    public static final Consumer<Result> DEFAULT_CALLBACK = result -> {
        if (result != Result.OK) {
            throw new GameSDKException((Result)((Object)result));
        }
    };
    public static final BiConsumer<LogLevel, String> DEFAULT_LOG_HOOK = (logLevel, string) -> System.out.printf("[%s] %s\n", logLevel, string);
    private final DiscordChannel channel;
    private ConnectionState state;
    private final Gson gson;
    private long nonce;
    private final Map<String, Consumer<Command>> handlers;
    private final Events events;
    private final DiscordEventAdapter eventAdapter;
    private BiConsumer<LogLevel, String> logHook = DEFAULT_LOG_HOOK;
    private LogLevel minLogLevel = LogLevel.VERBOSE;
    private final CorePrivate corePrivate;
    private final CreateParams createParams;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final ActivityManager activityManager;
    private final UserManager userManager;
    private final OverlayManager overlayManager;
    private final RelationshipManager relationshipManager;
    private final ImageManager imageManager;
    private final VoiceManager voiceManager;

    public static final DiscordChannel getDiscordChannel() throws IOException {
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
            return new WindowsDiscordChannel();
        }
        return new UnixDiscordChannel();
    }

    public Core(CreateParams createParams) {
        this.createParams = createParams;
        this.state = ConnectionState.HANDSHAKE;
        this.gson = new Gson();
        this.nonce = 0L;
        this.handlers = new HashMap<String, Consumer<Command>>();
        this.corePrivate = new CorePrivate();
        this.events = new Events(this.corePrivate);
        this.eventAdapter = this.createParams.eventAdapter;
        try {
            this.channel = Core.getDiscordChannel();
            this.sendHandshake();
            this.runCallbacks();
            this.channel.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.activityManager = new ActivityManager(this.corePrivate);
        this.overlayManager = new OverlayManager(this.corePrivate);
        this.userManager = new UserManager(this.corePrivate);
        this.relationshipManager = new RelationshipManager(this.corePrivate);
        this.imageManager = new ImageManager(this.corePrivate);
        this.voiceManager = new VoiceManager(this.corePrivate);
    }

    private void sendString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + 8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(this.state.ordinal());
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        this.channel.write(byteBuffer.flip());
        this.corePrivate.log(LogLevel.VERBOSE, "Sent string \"" + string + "\" at state " + this.state);
    }

    private Res receiveString() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        this.channel.read(byteBuffer);
        byteBuffer.flip();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (byteBuffer.remaining() == 0) {
            return null;
        }
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        int n3 = 0;
        while ((n3 += (int)this.channel.read(new ByteBuffer[]{byteBuffer2}, 0, 1)) < n2) {
        }
        String string = new String(byteBuffer2.flip().array());
        ConnectionState connectionState = ConnectionState.values()[n];
        this.corePrivate.log(LogLevel.VERBOSE, "Received string \"" + string + "\" at state " + connectionState);
        return new Res(connectionState, string);
    }

    private void sendCommand(Command command, Consumer<Command> consumer) {
        this.handlers.put(command.getNonce(), consumer);
        try {
            this.sendString(this.gson.toJson(command));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void sendHandshake() throws IOException {
        HandshakeMessage handshakeMessage = new HandshakeMessage(Long.toString(this.createParams.getClientID()));
        this.sendString(this.gson.toJson(handshakeMessage));
    }

    private void registerEvents() {
        for (Map.Entry<Command.Event, EventHandler<?>> entry : this.events.getEventTypes()) {
            Command.Event event = entry.getKey();
            EventHandler<?> eventHandler = entry.getValue();
            if (!eventHandler.shouldRegister()) continue;
            Command command2 = new Command();
            command2.setCmd(Command.Type.SUBSCRIBE);
            command2.setEvt(event);
            command2.setArgs(this.gson.toJsonTree(eventHandler.getRegisterArgs()));
            command2.setNonce(Long.toString(++this.nonce));
            this.sendCommand(command2, command -> this.corePrivate.log(LogLevel.DEBUG, "Registered event " + this.gson.fromJson(command.getData(), Subscribe.Response.class).getEvent()));
        }
    }

    private Command receiveCommand() throws IOException {
        Res res = this.receiveString();
        if (res == null) {
            return null;
        }
        return this.gson.fromJson(res.data, Command.class);
    }

    private void handleCommand(Command command) {
        if (command.getNonce() != null) {
            this.handlers.remove(command.getNonce()).accept(command);
        } else if (command.getEvent() != null) {
            EventHandler<?> eventHandler = this.events.forEvent(command.getEvent());
            Object obj = this.gson.fromJson(command.getData(), eventHandler.getDataClass());
            eventHandler.handleObject(command, obj);
        }
    }

    public ActivityManager activityManager() {
        return this.activityManager;
    }

    public UserManager userManager() {
        return this.userManager;
    }

    public OverlayManager overlayManager() {
        return this.overlayManager;
    }

    public RelationshipManager relationshipManager() {
        return this.relationshipManager;
    }

    public ImageManager imageManager() {
        return this.imageManager;
    }

    public VoiceManager voiceManager() {
        return this.voiceManager;
    }

    public void runCallbacks() {
        Runnable runnable;
        while ((runnable = this.corePrivate.workQueue.poll()) != null) {
            runnable.run();
        }
        try {
            Command command = this.receiveCommand();
            if (command != null) {
                this.handleCommand(command);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void setLogHook(LogLevel logLevel, BiConsumer<LogLevel, String> biConsumer) {
        this.logHook = biConsumer;
        this.minLogLevel = logLevel;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public class CorePrivate {
        public Queue<Runnable> workQueue = new ArrayDeque<Runnable>();
        public int pid = (int)ProcessHandle.current().pid();
        public DiscordUser currentUser;
        public Map<Long, Relationship> relationships = new HashMap<Long, Relationship>();
        public OverlayUpdateEvent.Data overlayData = new OverlayUpdateEvent.Data();
        public VoiceSettingsUpdate2Event.Data voiceData = new VoiceSettingsUpdate2Event.Data();
        private static final DiscordEventAdapter NULL_ADAPTER = new DiscordEventAdapter(){};

        private CorePrivate() {
        }

        public DiscordEventAdapter getEventAdapter() {
            return Optional.ofNullable(Core.this.eventAdapter).orElse(NULL_ADAPTER);
        }

        public void ready() {
            Core.this.state = ConnectionState.CONNECTED;
            Core.this.registerEvents();
        }

        public Core getCore() {
            return Core.this;
        }

        public void sendCommand(Command.Type type, Object object, Consumer<Command> consumer) {
            Command command = new Command();
            command.setCmd(type);
            command.setArgs(Core.this.gson.toJsonTree(object).getAsJsonObject());
            command.setNonce(Long.toString(++Core.this.nonce));
            Core.this.sendCommand(command, consumer);
        }

        public void sendCommandNoResponse(Command.Type type, Object object, Consumer<Command> consumer) {
            Command command = new Command();
            command.setCmd(type);
            command.setArgs(Core.this.gson.toJsonTree(object).getAsJsonObject());
            command.setNonce(Long.toString(0L));
            try {
                Core.this.sendString(Core.this.gson.toJson(command));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            Core.this.corePrivate.workQueue.add(() -> {
                Command command = new Command();
                command.setEvt(null);
                command.setNonce(Long.toString(0L));
                command.setCmd(type);
                command.setData(null);
                consumer.accept(command);
            });
        }

        public Gson getGson() {
            return Core.this.gson;
        }

        public void log(LogLevel logLevel, String string) {
            if (logLevel.compareTo(Core.this.minLogLevel) <= 0) {
                Core.this.logHook.accept(logLevel, string);
            }
        }

        public Result checkError(Command command) {
            if (command.getEvent() == Command.Event.ERROR) {
                Error error = Core.this.gson.fromJson(command.getData(), Error.class);
                this.log(LogLevel.ERROR, error.getMessage());
                return Result.fromCode(error.getCode());
            }
            return Result.OK;
        }
    }

    private static class Res {
        public ConnectionState result;
        public String data;

        public Res(ConnectionState connectionState, String string) {
            this.result = connectionState;
            this.data = string;
        }
    }
}

